/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.service.convert.docTo;

import cn.ljserver.tool.weboffice.v3.exception.InvalidArgument;
import cn.ljserver.tool.weboffice.v3.model.convert.ConvertResponse;
import cn.ljserver.tool.weboffice.v3.model.convert.DocToPdfRequest;
import cn.ljserver.tool.weboffice.v3.util.ConvertUtils;
import cn.ljserver.tool.weboffice.v3.util.FileUtils;

public class DocToPdf {
    public static ConvertResponse convert(DocToPdfRequest r) {
        DocToPdf.checkUrl(r.getUrl());
        String uri = "/api/developer/v1/office/convert/to/pdf";
        return ConvertUtils.post(uri, r, ConvertResponse.class);
    }

    public static ConvertResponse convert(String url) {
        return DocToPdf.convert(new DocToPdfRequest(url));
    }

    public static ConvertResponse convert(String url, String fileName) {
        return DocToPdf.convert(new DocToPdfRequest(url, fileName));
    }

    public static ConvertResponse convert(String url, String fileName, String password) {
        return DocToPdf.convert(new DocToPdfRequest(url, fileName, password));
    }

    private static void checkUrl(String url) {
        if (url == null || url.isEmpty()) {
            throw new InvalidArgument();
        }
        String fileType = FileUtils.suffix(url);
        if ("pdf".equalsIgnoreCase(fileType)) {
            throw new InvalidArgument("url file is a pdf file now !");
        }
        FileUtils.typeMatchCheck(FileUtils.documentConvertTypes, fileType);
    }
}

