/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.service;

import cn.ljserver.tool.weboffice.v3.exception.ConvertErrorCodes;
import cn.ljserver.tool.weboffice.v3.model.FileTemplateResponse;
import cn.ljserver.tool.weboffice.v3.model.ProviderResponseEntity;
import cn.ljserver.tool.weboffice.v3.util.ConvertUtils;
import cn.ljserver.tool.weboffice.v3.util.FileUtils;

public class FileTemplateService {
    public static ProviderResponseEntity<?> getFileTemplateResponse(String officeType) {
        FileTemplateResponse response = FileTemplateService.getFileTemplate(officeType);
        if (response != null && response.getCode() == 0) {
            return ProviderResponseEntity.ok(response.getData());
        }
        if (response == null) {
            return ProviderResponseEntity.err(ConvertErrorCodes.Unknown);
        }
        return ProviderResponseEntity.err(ConvertErrorCodes.getByCode(response.getCode()));
    }

    public static FileTemplateResponse getFileTemplate(String officeType) {
        FileUtils.typeMatchCheck(FileUtils.templateTypes, officeType);
        String uri = "/api/developer/v1/files/" + officeType.toLowerCase() + "/template";
        return ConvertUtils.get(uri, FileTemplateResponse.class);
    }
}

