/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.model.convert;

import cn.ljserver.tool.weboffice.v3.util.FileUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.org.glassfish.gmbal.Description;
import lombok.NonNull;

public class OfficeToRequest {
    @JsonProperty(value="url")
    @Description(value="\u6587\u6863\u4e0b\u8f7d\u5730\u5740")
    @NonNull
    public String url;
    @JsonProperty(value="filename")
    @Description(value="\u6587\u6863\u540d\u79f0\uff0c\u5305\u542b\u6269\u5c55\u540d\uff0c\u4f8b\u5982\uff1a \u6587\u5b57\u6587\u7a3f.docx")
    @NonNull
    public String filename;
    @JsonProperty(value="password")
    @Description(value="\u6587\u6863\u6253\u5f00\u5bc6\u7801(\u5982\u679c\u6587\u6863\u6709\u52a0\u5bc6\uff0c\u8be5\u9879\u5219\u5fc5\u586b)")
    public String password;

    public OfficeToRequest(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
        this.filename = FileUtils.name(url);
    }

    public OfficeToRequest(@NonNull String url, @NonNull String filename) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.url = url;
        this.filename = filename;
    }

    public OfficeToRequest(@NonNull String url, @NonNull String filename, String password) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.url = url;
        this.filename = filename;
        this.password = password;
    }

    public static OfficeToRequestBuilder builder() {
        return new OfficeToRequestBuilder();
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getFilename() {
        return this.filename;
    }

    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="url")
    public void setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    @JsonProperty(value="filename")
    public void setFilename(@NonNull String filename) {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.filename = filename;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfficeToRequest)) {
            return false;
        }
        OfficeToRequest other = (OfficeToRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OfficeToRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "OfficeToRequest(url=" + this.getUrl() + ", filename=" + this.getFilename() + ", password=" + this.getPassword() + ")";
    }

    public OfficeToRequest() {
    }

    public static class OfficeToRequestBuilder {
        private String url;
        private String filename;
        private String password;

        OfficeToRequestBuilder() {
        }

        @JsonProperty(value="url")
        public OfficeToRequestBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        @JsonProperty(value="filename")
        public OfficeToRequestBuilder filename(@NonNull String filename) {
            if (filename == null) {
                throw new NullPointerException("filename is marked non-null but is null");
            }
            this.filename = filename;
            return this;
        }

        @JsonProperty(value="password")
        public OfficeToRequestBuilder password(String password) {
            this.password = password;
            return this;
        }

        public OfficeToRequest build() {
            return new OfficeToRequest(this.url, this.filename, this.password);
        }

        public String toString() {
            return "OfficeToRequest.OfficeToRequestBuilder(url=" + this.url + ", filename=" + this.filename + ", password=" + this.password + ")";
        }
    }
}

