/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.model.convert;

import cn.ljserver.tool.weboffice.v3.util.FileUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.org.glassfish.gmbal.Description;
import lombok.NonNull;

public class DocToPdfRequest {
    @JsonProperty(value="url")
    @Description(value="\u6587\u6863\u4e0b\u8f7d\u5730\u5740")
    @NonNull
    public String url;
    @JsonProperty(value="filename")
    @Description(value="\u6587\u6863\u540d\u79f0\uff0c\u5305\u542b\u6269\u5c55\u540d\uff0c\u4f8b\u5982\uff1a \u6587\u5b57\u6587\u7a3f.docx")
    @NonNull
    public String filename;
    @JsonProperty(value="password")
    @Description(value="\u6587\u6863\u6253\u5f00\u5bc6\u7801(\u5982\u679c\u6587\u6863\u6709\u52a0\u5bc6\uff0c\u8be5\u9879\u5219\u5fc5\u586b)")
    public String password;
    @JsonProperty(value="ranges")
    @Description(value="\u81ea\u5b9a\u4e49\u9700\u8981\u8f6c\u6362\u7684\u5206\u9875\u8303\u56f4\uff0c\u4f8b\u5982\uff1a1,2-4,7\uff0c\u5219\u8868\u793a\u8f6c\u6362\u6587\u6863\u7684 1\u30012\u30014\u30017 \u9875\u9762 (\u4e0e from_page\u548cto_page \u4e92\u65a5)")
    private String ranges;
    @JsonProperty(value="from_page")
    @Description(value="\u8f6c\u6362\u8d77\u59cb\u9875\uff0c\u4ece 1 \u5f00\u59cb\u8ba1\u6570(\u4e0e ranges\u4e92\u65a5)")
    private Integer fromPage;
    @JsonProperty(value="to_page")
    @Description(value="\u8f6c\u6362\u7ed3\u675f\u9875\uff0c\u9700\u8981\u5927\u4e8e from_page\uff0c (\u4e0e ranges\u4e92\u65a5)")
    private Integer toPage;
    @JsonProperty(value="show_comments")
    @Description(value="\u662f\u5426\u663e\u793a\u6279\u6ce8\u3002\u9ed8\u8ba4\u503c\u4e3a false\uff0c\u4e0d\u663e\u793a\u6279\u6ce8")
    private boolean showComments = false;

    public DocToPdfRequest(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
        this.filename = FileUtils.name(url);
    }

    public DocToPdfRequest(@NonNull String url, @NonNull String filename) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.url = url;
        this.filename = filename;
    }

    public DocToPdfRequest(@NonNull String url, @NonNull String filename, String password) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.url = url;
        this.filename = filename;
        this.password = password;
    }

    public static DocToPdfRequestBuilder builder() {
        return new DocToPdfRequestBuilder();
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getFilename() {
        return this.filename;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRanges() {
        return this.ranges;
    }

    public Integer getFromPage() {
        return this.fromPage;
    }

    public Integer getToPage() {
        return this.toPage;
    }

    public boolean isShowComments() {
        return this.showComments;
    }

    @JsonProperty(value="url")
    public void setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    @JsonProperty(value="filename")
    public void setFilename(@NonNull String filename) {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.filename = filename;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty(value="ranges")
    public void setRanges(String ranges) {
        this.ranges = ranges;
    }

    @JsonProperty(value="from_page")
    public void setFromPage(Integer fromPage) {
        this.fromPage = fromPage;
    }

    @JsonProperty(value="to_page")
    public void setToPage(Integer toPage) {
        this.toPage = toPage;
    }

    @JsonProperty(value="show_comments")
    public void setShowComments(boolean showComments) {
        this.showComments = showComments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocToPdfRequest)) {
            return false;
        }
        DocToPdfRequest other = (DocToPdfRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShowComments() != other.isShowComments()) {
            return false;
        }
        Integer this$fromPage = this.getFromPage();
        Integer other$fromPage = other.getFromPage();
        if (this$fromPage == null ? other$fromPage != null : !((Object)this$fromPage).equals(other$fromPage)) {
            return false;
        }
        Integer this$toPage = this.getToPage();
        Integer other$toPage = other.getToPage();
        if (this$toPage == null ? other$toPage != null : !((Object)this$toPage).equals(other$toPage)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$ranges = this.getRanges();
        String other$ranges = other.getRanges();
        return !(this$ranges == null ? other$ranges != null : !this$ranges.equals(other$ranges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocToPdfRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowComments() ? 79 : 97);
        Integer $fromPage = this.getFromPage();
        result = result * 59 + ($fromPage == null ? 43 : ((Object)$fromPage).hashCode());
        Integer $toPage = this.getToPage();
        result = result * 59 + ($toPage == null ? 43 : ((Object)$toPage).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $ranges = this.getRanges();
        result = result * 59 + ($ranges == null ? 43 : $ranges.hashCode());
        return result;
    }

    public String toString() {
        return "DocToPdfRequest(url=" + this.getUrl() + ", filename=" + this.getFilename() + ", password=" + this.getPassword() + ", ranges=" + this.getRanges() + ", fromPage=" + this.getFromPage() + ", toPage=" + this.getToPage() + ", showComments=" + this.isShowComments() + ")";
    }

    public DocToPdfRequest() {
    }

    public DocToPdfRequest(@NonNull String url, @NonNull String filename, String password, String ranges, Integer fromPage, Integer toPage, boolean showComments) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.url = url;
        this.filename = filename;
        this.password = password;
        this.ranges = ranges;
        this.fromPage = fromPage;
        this.toPage = toPage;
        this.showComments = showComments;
    }

    public static class DocToPdfRequestBuilder {
        private String url;
        private String filename;
        private String password;
        private String ranges;
        private Integer fromPage;
        private Integer toPage;
        private boolean showComments;

        DocToPdfRequestBuilder() {
        }

        @JsonProperty(value="url")
        public DocToPdfRequestBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        @JsonProperty(value="filename")
        public DocToPdfRequestBuilder filename(@NonNull String filename) {
            if (filename == null) {
                throw new NullPointerException("filename is marked non-null but is null");
            }
            this.filename = filename;
            return this;
        }

        @JsonProperty(value="password")
        public DocToPdfRequestBuilder password(String password) {
            this.password = password;
            return this;
        }

        @JsonProperty(value="ranges")
        public DocToPdfRequestBuilder ranges(String ranges) {
            this.ranges = ranges;
            return this;
        }

        @JsonProperty(value="from_page")
        public DocToPdfRequestBuilder fromPage(Integer fromPage) {
            this.fromPage = fromPage;
            return this;
        }

        @JsonProperty(value="to_page")
        public DocToPdfRequestBuilder toPage(Integer toPage) {
            this.toPage = toPage;
            return this;
        }

        @JsonProperty(value="show_comments")
        public DocToPdfRequestBuilder showComments(boolean showComments) {
            this.showComments = showComments;
            return this;
        }

        public DocToPdfRequest build() {
            return new DocToPdfRequest(this.url, this.filename, this.password, this.ranges, this.fromPage, this.toPage, this.showComments);
        }

        public String toString() {
            return "DocToPdfRequest.DocToPdfRequestBuilder(url=" + this.url + ", filename=" + this.filename + ", password=" + this.password + ", ranges=" + this.ranges + ", fromPage=" + this.fromPage + ", toPage=" + this.toPage + ", showComments=" + this.showComments + ")";
        }
    }
}

