/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.model.convert;

import cn.ljserver.tool.weboffice.v3.util.FileUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.org.glassfish.gmbal.Description;
import lombok.NonNull;

public class DocToImgRequest {
    @JsonProperty(value="url")
    @Description(value="\u6587\u6863\u4e0b\u8f7d\u5730\u5740")
    @NonNull
    public String url;
    @JsonProperty(value="filename")
    @Description(value="\u6587\u6863\u540d\u79f0\uff0c\u5305\u542b\u6269\u5c55\u540d\uff0c\u4f8b\u5982\uff1a \u6587\u5b57\u6587\u7a3f.docx")
    @NonNull
    public String filename;
    @JsonProperty(value="password")
    @Description(value="\u6587\u6863\u6253\u5f00\u5bc6\u7801(\u5982\u679c\u6587\u6863\u6709\u52a0\u5bc6\uff0c\u8be5\u9879\u5219\u5fc5\u586b)")
    public String password;
    @JsonProperty(value="long_pic")
    @Description(value="\u662f\u5426\u8f6c\u6362\u6210\u5355\u5f20\u957f\u56fe\uff0c\u8bbe\u7f6e\u4e3a true \u65f6\uff0c\u6700\u591a\u4ec5\u652f\u6301\u5c06 20 \u6807\u51c6\u9875\u9762\u5408\u6210\u5355\u5f20\u957f\u56fe\uff0c\u8d85\u8fc7\u53ef\u80fd\u4f1a\u62a5\u9519")
    private boolean longPic = false;
    @JsonProperty(value="image_dpi")
    @Description(value="\u6309\u6307\u5b9a dpi \u6e32\u67d3\u56fe\u7247\uff0c\u8be5\u53c2\u6570\u4e0e scale \u5171\u540c\u4f5c\u7528\uff0c\u53d6\u503c\u8303\u56f4 96-600\u3002\u9ed8\u8ba4\u503c\u4e3a 96\u3002")
    private int image_dpi = 96;
    @JsonProperty(value="scale")
    @Description(value="\u7f29\u653e\u53c2\u6570\uff0c\u5141\u8bb8\u8303\u56f4\u662f 20-200\uff0c100 \u8868\u793a\u4e0d\u7f29\u653e\uff0c\u5c0f\u4e8e 100 \u8868\u793a\u662f\u7f29\u5c0f\uff0c\u5927\u4e8e 100 \u8868\u793a\u662f\u653e\u5927\u3002 \u9ed8\u8ba4\u503c\u4e3a 100")
    private int scale = 100;
    @JsonProperty(value="quality")
    @Description(value="\u8d28\u91cf\u53c2\u6570\uff0c\u8303\u56f4\u662f 0-100\uff0c\u8d8a\u5927\u8868\u793a\u8d28\u91cf\u8d8a\u597d")
    private int quality = 20;
    @JsonProperty(value="show_comments")
    @Description(value="\u662f\u5426\u663e\u793a\u6279\u6ce8\u3002\u9ed8\u8ba4\u503c\u4e3a false\uff0c\u4e0d\u663e\u793a\u6279\u6ce8")
    private boolean show_comments = false;
    @JsonProperty(value="fit_to_width")
    @Description(value="\u503c\u4e3a 1 \u8868\u793a\u5c06\u6240\u6709\u5217\u653e\u5230 \u4e00 \u9875\u4e2d\u8fdb\u884c\u6392\u7248\uff0c\u9ed8\u8ba4\u503c\u4e3a 0 (\u8be5\u5b57\u6bb5\u53ea\u5728 ET \u8868\u683c\u4e2d\u751f\u6548)")
    private int fit_to_width = 0;
    @JsonProperty(value="fit_to_height")
    @Description(value="\u503c\u4e3a 1 \u8868\u793a\u5c06\u6240\u6709\u884c\u653e\u5230 \u4e00 \u9875\u8fdb\u884c\u6392\u7248\uff0c\u9ed8\u8ba4\u503c\u4e3a 0 (\u8be5\u5b57\u6bb5\u53ea\u5728 ET \u8868\u683c\u4e2d\u751f\u6548)")
    private int fit_to_height = 0;
    @JsonProperty(value="is_horizontal")
    @Description(value="\u503c\u4e3a true \u8868\u793a\u7eb8\u5f20\u662f\u6c34\u5e73\u653e\u7f6e\u3002\u9ed8\u8ba4\u503c\u4e3a false\uff0c\u7eb8\u5f20\u5782\u76f4\u653e\u7f6e (\u8be5\u5b57\u6bb5\u53ea\u5728 ET \u8868\u683c\u4e2d\u751f\u6548)")
    private boolean is_horizontal = false;
    @JsonProperty(value="paper_size")
    @Description(value="\u8bbe\u7f6e\u7eb8\u5f20\uff08\u753b\u5e03\uff09\u5927\u5c0f\uff0c\u5bf9\u5e94\u4fe1\u606f\u4e3a\uff1a0 \u2192 A4; 1 \u2192 A2; 2 \u2192 A0\u3002\u9ed8\u8ba4 A4 \u7eb8\u5f20 (\u8be5\u5b57\u6bb5\u53ea\u5728 ET \u8868\u683c\u4e2d\u751f\u6548)")
    private int paper_size = 0;
    @JsonProperty(value="ranges")
    @Description(value="\u81ea\u5b9a\u4e49\u9700\u8981\u8f6c\u6362\u7684\u5206\u9875\u8303\u56f4\uff0c\u4f8b\u5982\uff1a1,2-4,7\uff0c\u5219\u8868\u793a\u8f6c\u6362\u6587\u6863\u7684 1\u30012\u30014\u30017 \u9875\u9762 (\u4e0e from_page\u548cto_page \u4e92\u65a5)")
    private String ranges;
    @JsonProperty(value="from_page")
    @Description(value="\u8f6c\u6362\u8d77\u59cb\u9875\uff0c\u4ece 1 \u5f00\u59cb\u8ba1\u6570(\u4e0e ranges\u4e92\u65a5)")
    private Integer fromPage;
    @JsonProperty(value="to_page")
    @Description(value="\u8f6c\u6362\u7ed3\u675f\u9875\uff0c\u9700\u8981\u5927\u4e8e from_page\uff0c (\u4e0e ranges\u4e92\u65a5)")
    private Integer toPage;

    public DocToImgRequest(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
        this.filename = FileUtils.name(url);
    }

    public DocToImgRequest(@NonNull String url, @NonNull String filename) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.url = url;
        this.filename = filename;
    }

    public DocToImgRequest(@NonNull String url, @NonNull String filename, String password) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.url = url;
        this.filename = filename;
        this.password = password;
    }

    public static DocToImgRequestBuilder builder() {
        return new DocToImgRequestBuilder();
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getFilename() {
        return this.filename;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isLongPic() {
        return this.longPic;
    }

    public int getImage_dpi() {
        return this.image_dpi;
    }

    public int getScale() {
        return this.scale;
    }

    public int getQuality() {
        return this.quality;
    }

    public boolean isShow_comments() {
        return this.show_comments;
    }

    public int getFit_to_width() {
        return this.fit_to_width;
    }

    public int getFit_to_height() {
        return this.fit_to_height;
    }

    public boolean is_horizontal() {
        return this.is_horizontal;
    }

    public int getPaper_size() {
        return this.paper_size;
    }

    public String getRanges() {
        return this.ranges;
    }

    public Integer getFromPage() {
        return this.fromPage;
    }

    public Integer getToPage() {
        return this.toPage;
    }

    @JsonProperty(value="url")
    public void setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    @JsonProperty(value="filename")
    public void setFilename(@NonNull String filename) {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.filename = filename;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty(value="long_pic")
    public void setLongPic(boolean longPic) {
        this.longPic = longPic;
    }

    @JsonProperty(value="image_dpi")
    public void setImage_dpi(int image_dpi) {
        this.image_dpi = image_dpi;
    }

    @JsonProperty(value="scale")
    public void setScale(int scale) {
        this.scale = scale;
    }

    @JsonProperty(value="quality")
    public void setQuality(int quality) {
        this.quality = quality;
    }

    @JsonProperty(value="show_comments")
    public void setShow_comments(boolean show_comments) {
        this.show_comments = show_comments;
    }

    @JsonProperty(value="fit_to_width")
    public void setFit_to_width(int fit_to_width) {
        this.fit_to_width = fit_to_width;
    }

    @JsonProperty(value="fit_to_height")
    public void setFit_to_height(int fit_to_height) {
        this.fit_to_height = fit_to_height;
    }

    @JsonProperty(value="is_horizontal")
    public void set_horizontal(boolean is_horizontal) {
        this.is_horizontal = is_horizontal;
    }

    @JsonProperty(value="paper_size")
    public void setPaper_size(int paper_size) {
        this.paper_size = paper_size;
    }

    @JsonProperty(value="ranges")
    public void setRanges(String ranges) {
        this.ranges = ranges;
    }

    @JsonProperty(value="from_page")
    public void setFromPage(Integer fromPage) {
        this.fromPage = fromPage;
    }

    @JsonProperty(value="to_page")
    public void setToPage(Integer toPage) {
        this.toPage = toPage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocToImgRequest)) {
            return false;
        }
        DocToImgRequest other = (DocToImgRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLongPic() != other.isLongPic()) {
            return false;
        }
        if (this.getImage_dpi() != other.getImage_dpi()) {
            return false;
        }
        if (this.getScale() != other.getScale()) {
            return false;
        }
        if (this.getQuality() != other.getQuality()) {
            return false;
        }
        if (this.isShow_comments() != other.isShow_comments()) {
            return false;
        }
        if (this.getFit_to_width() != other.getFit_to_width()) {
            return false;
        }
        if (this.getFit_to_height() != other.getFit_to_height()) {
            return false;
        }
        if (this.is_horizontal() != other.is_horizontal()) {
            return false;
        }
        if (this.getPaper_size() != other.getPaper_size()) {
            return false;
        }
        Integer this$fromPage = this.getFromPage();
        Integer other$fromPage = other.getFromPage();
        if (this$fromPage == null ? other$fromPage != null : !((Object)this$fromPage).equals(other$fromPage)) {
            return false;
        }
        Integer this$toPage = this.getToPage();
        Integer other$toPage = other.getToPage();
        if (this$toPage == null ? other$toPage != null : !((Object)this$toPage).equals(other$toPage)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$ranges = this.getRanges();
        String other$ranges = other.getRanges();
        return !(this$ranges == null ? other$ranges != null : !this$ranges.equals(other$ranges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocToImgRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLongPic() ? 79 : 97);
        result = result * 59 + this.getImage_dpi();
        result = result * 59 + this.getScale();
        result = result * 59 + this.getQuality();
        result = result * 59 + (this.isShow_comments() ? 79 : 97);
        result = result * 59 + this.getFit_to_width();
        result = result * 59 + this.getFit_to_height();
        result = result * 59 + (this.is_horizontal() ? 79 : 97);
        result = result * 59 + this.getPaper_size();
        Integer $fromPage = this.getFromPage();
        result = result * 59 + ($fromPage == null ? 43 : ((Object)$fromPage).hashCode());
        Integer $toPage = this.getToPage();
        result = result * 59 + ($toPage == null ? 43 : ((Object)$toPage).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $ranges = this.getRanges();
        result = result * 59 + ($ranges == null ? 43 : $ranges.hashCode());
        return result;
    }

    public String toString() {
        return "DocToImgRequest(url=" + this.getUrl() + ", filename=" + this.getFilename() + ", password=" + this.getPassword() + ", longPic=" + this.isLongPic() + ", image_dpi=" + this.getImage_dpi() + ", scale=" + this.getScale() + ", quality=" + this.getQuality() + ", show_comments=" + this.isShow_comments() + ", fit_to_width=" + this.getFit_to_width() + ", fit_to_height=" + this.getFit_to_height() + ", is_horizontal=" + this.is_horizontal() + ", paper_size=" + this.getPaper_size() + ", ranges=" + this.getRanges() + ", fromPage=" + this.getFromPage() + ", toPage=" + this.getToPage() + ")";
    }

    public DocToImgRequest() {
    }

    public DocToImgRequest(@NonNull String url, @NonNull String filename, String password, boolean longPic, int image_dpi, int scale, int quality, boolean show_comments, int fit_to_width, int fit_to_height, boolean is_horizontal, int paper_size, String ranges, Integer fromPage, Integer toPage) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.url = url;
        this.filename = filename;
        this.password = password;
        this.longPic = longPic;
        this.image_dpi = image_dpi;
        this.scale = scale;
        this.quality = quality;
        this.show_comments = show_comments;
        this.fit_to_width = fit_to_width;
        this.fit_to_height = fit_to_height;
        this.is_horizontal = is_horizontal;
        this.paper_size = paper_size;
        this.ranges = ranges;
        this.fromPage = fromPage;
        this.toPage = toPage;
    }

    public static class DocToImgRequestBuilder {
        private String url;
        private String filename;
        private String password;
        private boolean longPic;
        private int image_dpi;
        private int scale;
        private int quality;
        private boolean show_comments;
        private int fit_to_width;
        private int fit_to_height;
        private boolean is_horizontal;
        private int paper_size;
        private String ranges;
        private Integer fromPage;
        private Integer toPage;

        DocToImgRequestBuilder() {
        }

        @JsonProperty(value="url")
        public DocToImgRequestBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        @JsonProperty(value="filename")
        public DocToImgRequestBuilder filename(@NonNull String filename) {
            if (filename == null) {
                throw new NullPointerException("filename is marked non-null but is null");
            }
            this.filename = filename;
            return this;
        }

        @JsonProperty(value="password")
        public DocToImgRequestBuilder password(String password) {
            this.password = password;
            return this;
        }

        @JsonProperty(value="long_pic")
        public DocToImgRequestBuilder longPic(boolean longPic) {
            this.longPic = longPic;
            return this;
        }

        @JsonProperty(value="image_dpi")
        public DocToImgRequestBuilder image_dpi(int image_dpi) {
            this.image_dpi = image_dpi;
            return this;
        }

        @JsonProperty(value="scale")
        public DocToImgRequestBuilder scale(int scale) {
            this.scale = scale;
            return this;
        }

        @JsonProperty(value="quality")
        public DocToImgRequestBuilder quality(int quality) {
            this.quality = quality;
            return this;
        }

        @JsonProperty(value="show_comments")
        public DocToImgRequestBuilder show_comments(boolean show_comments) {
            this.show_comments = show_comments;
            return this;
        }

        @JsonProperty(value="fit_to_width")
        public DocToImgRequestBuilder fit_to_width(int fit_to_width) {
            this.fit_to_width = fit_to_width;
            return this;
        }

        @JsonProperty(value="fit_to_height")
        public DocToImgRequestBuilder fit_to_height(int fit_to_height) {
            this.fit_to_height = fit_to_height;
            return this;
        }

        @JsonProperty(value="is_horizontal")
        public DocToImgRequestBuilder is_horizontal(boolean is_horizontal) {
            this.is_horizontal = is_horizontal;
            return this;
        }

        @JsonProperty(value="paper_size")
        public DocToImgRequestBuilder paper_size(int paper_size) {
            this.paper_size = paper_size;
            return this;
        }

        @JsonProperty(value="ranges")
        public DocToImgRequestBuilder ranges(String ranges) {
            this.ranges = ranges;
            return this;
        }

        @JsonProperty(value="from_page")
        public DocToImgRequestBuilder fromPage(Integer fromPage) {
            this.fromPage = fromPage;
            return this;
        }

        @JsonProperty(value="to_page")
        public DocToImgRequestBuilder toPage(Integer toPage) {
            this.toPage = toPage;
            return this;
        }

        public DocToImgRequest build() {
            return new DocToImgRequest(this.url, this.filename, this.password, this.longPic, this.image_dpi, this.scale, this.quality, this.show_comments, this.fit_to_width, this.fit_to_height, this.is_horizontal, this.paper_size, this.ranges, this.fromPage, this.toPage);
        }

        public String toString() {
            return "DocToImgRequest.DocToImgRequestBuilder(url=" + this.url + ", filename=" + this.filename + ", password=" + this.password + ", longPic=" + this.longPic + ", image_dpi=" + this.image_dpi + ", scale=" + this.scale + ", quality=" + this.quality + ", show_comments=" + this.show_comments + ", fit_to_width=" + this.fit_to_width + ", fit_to_height=" + this.fit_to_height + ", is_horizontal=" + this.is_horizontal + ", paper_size=" + this.paper_size + ", ranges=" + this.ranges + ", fromPage=" + this.fromPage + ", toPage=" + this.toPage + ")";
        }
    }
}

