/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.controller;

import cn.ljserver.tool.weboffice.v3.controller.ProviderBaseController;
import cn.ljserver.tool.weboffice.v3.controller.ProviderJsonApi;
import cn.ljserver.tool.weboffice.v3.exception.InvalidArgument;
import cn.ljserver.tool.weboffice.v3.exception.NotImplementException;
import cn.ljserver.tool.weboffice.v3.model.DownloadInfo;
import cn.ljserver.tool.weboffice.v3.model.FileInfo;
import cn.ljserver.tool.weboffice.v3.model.FileRenameRequest;
import cn.ljserver.tool.weboffice.v3.model.ProviderResponseEntity;
import cn.ljserver.tool.weboffice.v3.model.Watermark;
import cn.ljserver.tool.weboffice.v3.service.ExtendCapacityService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/3rd/files"})
public class ExtendCapacityController
extends ProviderBaseController {
    private ExtendCapacityService service;

    @PutMapping(value={"/{file_id}/name"})
    @ProviderJsonApi
    public ProviderResponseEntity<Map<String, String>> fileRename(@PathVariable(value="file_id") String fileId, @RequestBody FileRenameRequest request) {
        String name = request.getName();
        if (name == null || name.trim().isEmpty()) {
            throw new InvalidArgument("new filename is empty");
        }
        this.getServiceOrThrow().renameFile(fileId, name);
        return ProviderResponseEntity.ok(Collections.emptyMap());
    }

    @GetMapping(value={"/{file_id}/versions"})
    @ProviderJsonApi
    public ProviderResponseEntity<List<FileInfo>> fileVersions(@PathVariable(value="file_id") String fileId, @RequestParam(value="offset", required=false, defaultValue="0") int offset, @RequestParam(value="limit", required=false, defaultValue="100") int limit) {
        return ProviderResponseEntity.ok(this.getServiceOrThrow().fileVersions(fileId, offset, limit));
    }

    @GetMapping(value={"/{file_id}/versions/{version}"})
    @ProviderJsonApi
    public ProviderResponseEntity<FileInfo> fileVersion(@PathVariable(value="file_id") String fileId, @PathVariable(value="version") int version) {
        return ProviderResponseEntity.ok(this.getServiceOrThrow().fileVersion(fileId, version));
    }

    @GetMapping(value={"/{file_id}/versions/{version}/download"})
    @ProviderJsonApi
    public ProviderResponseEntity<DownloadInfo> fileVersionDownload(@PathVariable(value="file_id") String fileId, @PathVariable(value="version") int version) {
        return ProviderResponseEntity.ok(this.getServiceOrThrow().fileVersionDownload(fileId, version));
    }

    @GetMapping(value={"/{file_id}/watermark"})
    @ProviderJsonApi
    public ProviderResponseEntity<Watermark> fileWatermark(@PathVariable(value="file_id") String fileId) {
        return ProviderResponseEntity.ok(this.getServiceOrThrow().fileWatermark(fileId));
    }

    @Autowired(required=false)
    public void setService(ExtendCapacityService service) {
        this.service = service;
    }

    private ExtendCapacityService getServiceOrThrow() {
        if (Objects.isNull(this.service)) {
            String msg = String.format("request path %s not implement with interface class %s ", this.getRequestPath(), "ExtendCapacityService");
            throw new NotImplementException(msg);
        }
        return this.service;
    }
}

