/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.controller;

import cn.ljserver.tool.weboffice.v3.controller.ProviderBaseController;
import cn.ljserver.tool.weboffice.v3.controller.ProviderJsonApi;
import cn.ljserver.tool.weboffice.v3.exception.NotImplementException;
import cn.ljserver.tool.weboffice.v3.model.ProviderResponseEntity;
import cn.ljserver.tool.weboffice.v3.service.ExtendCapacityService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v3/3rd/object"})
public class AttachmentController
extends ProviderBaseController {
    private ExtendCapacityService service;

    @PutMapping(value={"/{key}"})
    @ProviderJsonApi
    public ProviderResponseEntity<?> uploadAttachment(@PathVariable String key, @RequestParam String name, @RequestBody MultipartFile files) {
        this.getServiceOrThrow().uploadAttachment(key, name, files);
        return ProviderResponseEntity.ok("");
    }

    @GetMapping(value={"/{key}/url"})
    @ProviderJsonApi
    public ProviderResponseEntity<?> getAttachment(@PathVariable String key, @RequestParam int scale_max_fit_width, @RequestParam int scale_max_fit_height, @RequestParam int scale_long_edge) {
        HashMap<String, String> res = new HashMap<String, String>();
        String url = this.getServiceOrThrow().getAttachment(key, scale_max_fit_width, scale_max_fit_height, scale_long_edge);
        res.put("url", url);
        return ProviderResponseEntity.ok(res);
    }

    @PostMapping(value={"/copy"})
    @ProviderJsonApi
    public ProviderResponseEntity<?> copyAttachment(@RequestBody Map<String, String> keyDict) {
        this.getServiceOrThrow().copyAttachment(keyDict);
        return ProviderResponseEntity.ok();
    }

    @Autowired(required=false)
    public void setService(ExtendCapacityService service) {
        this.service = service;
    }

    private ExtendCapacityService getServiceOrThrow() {
        if (Objects.isNull(this.service)) {
            String msg = String.format("request path %s not implement with interface class %s ", this.getRequestPath(), "ExtendCapacityService");
            throw new NotImplementException(msg);
        }
        return this.service;
    }
}

