/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.config;

import cn.ljserver.tool.weboffice.v3.config.WebOfficeProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"cn.ljserver.tool.weboffice.v3"})
public class WebOfficeAutoConfig {
    private final WebOfficeProperties webOfficeProperties;

    @Autowired
    public WebOfficeAutoConfig(WebOfficeProperties webOfficeProperties) {
        this.webOfficeProperties = webOfficeProperties;
    }

    @PostConstruct
    public void validateProperty() {
        Logger log = Logger.getLogger(this.getClass().getName());
        if (this.webOfficeProperties.getConvert() == null) {
            log.log(Level.WARNING, "web-office-v3: WARNING: Required application property 'web-office.convert' is null.");
        } else {
            if (this.webOfficeProperties.getConvert().getAppid() == null || this.webOfficeProperties.getConvert().getAppid().isEmpty()) {
                log.log(Level.WARNING, "web-office-v3: WARNING: Required application property 'web-office.convert.appid' is null or empty.");
            }
            if (this.webOfficeProperties.getConvert().getSecret() == null || this.webOfficeProperties.getConvert().getSecret().isEmpty()) {
                log.log(Level.WARNING, "web-office-v3: WARNING: Required application property 'web-office.convert.secret' is null or empty.");
            }
        }
        if (this.webOfficeProperties.getPreview() == null) {
            log.log(Level.WARNING, "web-office-v3: WARNING: Required application property 'web-office.preview' is null.");
        } else {
            if (this.webOfficeProperties.getPreview().getAppid() == null || this.webOfficeProperties.getPreview().getAppid().isEmpty()) {
                log.log(Level.WARNING, "web-office-v3: WARNING: Required application property 'web-office.preview.appid' is null or empty.");
            }
            if (this.webOfficeProperties.getPreview().getSecret() == null || this.webOfficeProperties.getPreview().getSecret().isEmpty()) {
                log.log(Level.WARNING, "web-office-v3: WARNING: Required application property 'web-office.preview.secret' is null or empty.");
            }
        }
    }
}

