/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.controller;

import cn.ljserver.tool.weboffice.v3.controller.ProviderBaseController;
import cn.ljserver.tool.weboffice.v3.controller.ProviderJsonApi;
import cn.ljserver.tool.weboffice.v3.model.DownloadInfo;
import cn.ljserver.tool.weboffice.v3.model.FileInfo;
import cn.ljserver.tool.weboffice.v3.model.ProviderResponseEntity;
import cn.ljserver.tool.weboffice.v3.model.UserPermission;
import cn.ljserver.tool.weboffice.v3.service.PreviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ResponseBody
@RequestMapping(value={"/v3/3rd/files"})
public class PreviewController
extends ProviderBaseController {
    private PreviewService previewService;

    @GetMapping(value={"/{file_id}"})
    @ProviderJsonApi
    public ProviderResponseEntity<FileInfo> fetchFile(@PathVariable(value="file_id") String fileId) {
        return ProviderResponseEntity.ok(this.previewService.fetchFileInfo(fileId));
    }

    @GetMapping(value={"/{file_id}/download"})
    @ProviderJsonApi
    public ProviderResponseEntity<DownloadInfo> fetchDownloadInfo(@PathVariable(value="file_id") String fileId) {
        return ProviderResponseEntity.ok(this.previewService.fetchDownloadInfo(fileId));
    }

    @GetMapping(value={"/{file_id}/permission"})
    @ProviderJsonApi
    public ProviderResponseEntity<UserPermission> fetchUserPermission(@PathVariable(value="file_id") String fileId) {
        return ProviderResponseEntity.ok(this.previewService.fetchUserPermission(fileId));
    }

    @Autowired(required=false)
    private void setPreviewService(PreviewService previewService) {
        this.previewService = previewService;
    }
}

