/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.controller;

import cn.ljserver.tool.weboffice.v3.controller.ProviderBaseController;
import cn.ljserver.tool.weboffice.v3.controller.ProviderJsonApi;
import cn.ljserver.tool.weboffice.v3.exception.NotImplementException;
import cn.ljserver.tool.weboffice.v3.model.FileInfo;
import cn.ljserver.tool.weboffice.v3.model.FileUploadMultiPhase;
import cn.ljserver.tool.weboffice.v3.model.FileUploadSinglePhase;
import cn.ljserver.tool.weboffice.v3.model.ProviderResponseEntity;
import cn.ljserver.tool.weboffice.v3.service.MultiPhaseFileStorageService;
import cn.ljserver.tool.weboffice.v3.service.SinglePhaseFileStorageService;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ResponseBody
@RequestMapping(value={"/v3/3rd/files"})
public class FileStorageController
extends ProviderBaseController {
    private MultiPhaseFileStorageService multiPhase;
    private SinglePhaseFileStorageService singlePhase;

    @GetMapping(value={"/{file_id}/upload/prepare"})
    @ProviderJsonApi
    public ProviderResponseEntity<Map<String, Object>> uploadPrepare(@PathVariable(value="file_id") String fileId) {
        return ProviderResponseEntity.ok(Collections.singletonMap("digest_types", this.getMultiPhaseServiceOrThrow().uploadPrepare(fileId)));
    }

    @PostMapping(value={"/{file_id}/upload/address"})
    public ProviderResponseEntity<FileUploadMultiPhase.FileUploadAddress.Response> uploadAddress(@PathVariable(value="file_id") String fileId, @RequestBody FileUploadMultiPhase.FileUploadAddress.Request request) {
        request.setFileId(fileId);
        return ProviderResponseEntity.ok(this.getMultiPhaseServiceOrThrow().uploadAddress(request));
    }

    @PostMapping(value={"/{file_id}/upload/complete"})
    @ProviderJsonApi
    public ProviderResponseEntity<FileInfo> uploadComplete(@PathVariable(value="file_id") String fileId, @RequestBody FileUploadMultiPhase.FileUploadComplete.Request request) {
        request.setFileId(fileId);
        return ProviderResponseEntity.ok(this.getMultiPhaseServiceOrThrow().uploadComplete(request));
    }

    @PostMapping(value={"/{file_id}/upload"}, consumes={"multipart/form-data"})
    @ProviderJsonApi
    public ProviderResponseEntity<FileInfo> uploadFile(@PathVariable(value="file_id") String fileId, @ModelAttribute FileUploadSinglePhase.Request request) {
        request.setFileId(fileId);
        return ProviderResponseEntity.ok(this.getSinglePhaseServiceOrThrow().uploadFile(request));
    }

    @Autowired(required=false)
    private void setMultiPhase(MultiPhaseFileStorageService multiPhase) {
        this.multiPhase = multiPhase;
    }

    @Autowired(required=false)
    private void setSinglePhase(SinglePhaseFileStorageService singlePhase) {
        this.singlePhase = singlePhase;
    }

    private MultiPhaseFileStorageService getMultiPhaseServiceOrThrow() {
        if (Objects.isNull(this.multiPhase)) {
            throw new NotImplementException(String.format("request path %s not implement", this.getRequestPath()));
        }
        return this.multiPhase;
    }

    private SinglePhaseFileStorageService getSinglePhaseServiceOrThrow() {
        if (Objects.isNull(this.singlePhase)) {
            throw new NotImplementException(String.format("request path %s not implement", this.getRequestPath()));
        }
        return this.singlePhase;
    }
}

