/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.config;

import cn.ljserver.tool.weboffice.v3.config.WebOfficeProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"cn.ljserver.tool.weboffice.v3"})
public class AutoConfig {
    private final WebOfficeProperties webOfficeProperties;

    @Autowired
    public AutoConfig(WebOfficeProperties webOfficeProperties) {
        this.webOfficeProperties = webOfficeProperties;
    }

    @PostConstruct
    public void validateProperty() {
        Logger log = Logger.getLogger(this.getClass().getName());
        if (this.webOfficeProperties.getAppid() == null || this.webOfficeProperties.getAppid().isEmpty()) {
            log.log(Level.WARNING, "web-office-v3: WARNING: Required application property 'web-office-v3.appid' is not or empty.");
        }
        if (this.webOfficeProperties.getSecret() == null || this.webOfficeProperties.getSecret().isEmpty()) {
            log.log(Level.WARNING, "web-office-v3: WARNING: Required application property 'web-office-v3.secret' is not or empty.");
        }
        if (this.webOfficeProperties.getDomain() == null || this.webOfficeProperties.getDomain().isEmpty()) {
            log.log(Level.WARNING, "web-office-v3: WARNING: Required application property 'web-office-v3.domain' is not or empty.");
        }
    }
}

