/*
 * Decompiled with CFR 0.152.
 */
package cn.lishaoshuai.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bytedeco.ffmpeg.ffmpeg;
import org.bytedeco.javacpp.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class FFMUtils {
    static final Logger logger = LoggerFactory.getLogger(FFMUtils.class);

    public static String executeCmd(List<String> commands, Integer tolerateTime) {
        long startTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(commands)) {
            throw new RuntimeException("ffmpeg\u6307\u4ee4\u4e3a\u7a7a");
        }
        LinkedList<String> ffmpegCommands = new LinkedList<String>(commands);
        ffmpegCommands.addFirst(Loader.load(ffmpeg.class));
        Process process = null;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        try {
            builder.redirectErrorStream(false);
            process = builder.command(ffmpegCommands).inheritIO().start();
            PrintStream inputStream = new PrintStream(process.getInputStream());
            PrintStream errorStream = new PrintStream(process.getErrorStream());
            inputStream.start();
            errorStream.start();
            if (Objects.isNull(tolerateTime)) {
                tolerateTime = 60;
            }
            process.waitFor(tolerateTime.intValue(), TimeUnit.SECONDS);
            String errorInfo = errorStream.stringBuffer.append(inputStream.stringBuffer).toString();
            if (!StringUtils.isEmpty((Object)errorInfo)) {
                logger.error("-- \u6267\u884cffmpeg\u547d\u4ee4\uff0c\u83b7\u53d6\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{} --", (Object)errorInfo);
            }
            String cmd = Arrays.toString(ffmpegCommands.toArray()).replace(",", "");
            logger.info("-- \u6267\u884cffmpeg\u547d\u4ee4\uff1a {} --", (Object)cmd);
            String string = process.exitValue() == 0 ? "ok" : "error";
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException("ffmpeg\u547d\u4ee4\u6267\u884c\u9519\u8bef: " + e.getMessage());
        }
        finally {
            Runtime runtime = Runtime.getRuntime();
            if (!ObjectUtils.isEmpty(process)) {
                ProcessKiller processKiller = new ProcessKiller(process);
                runtime.addShutdownHook(processKiller);
            }
            long costTime = System.currentTimeMillis() - startTime;
            logger.info("execute cost : {} milliseconds", (Object)costTime);
        }
    }

    static class PrintStream
    extends Thread {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();

        public PrintStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            try {
                String line;
                if (null == this.inputStream) {
                    logger.error("\u8bfb\u53d6\u8f93\u51fa\u6d41\u51fa\u9519\uff0c\u5f53\u524d\u8f93\u51fa\u6d41\u4e3a\u7a7a");
                }
                this.bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
                while ((line = this.bufferedReader.readLine()) != null) {
                    this.stringBuffer.append(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u8bfb\u53d6\u8f93\u5165\u6d41\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            }
            finally {
                try {
                    if (null != this.bufferedReader) {
                        this.bufferedReader.close();
                    }
                    if (null != this.inputStream) {
                        this.inputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.error("\u5173\u95ed\u6d41\u51fa\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }

    private static class ProcessKiller
    extends Thread {
        private final Process process;

        public ProcessKiller(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            this.process.destroyForcibly();
        }
    }
}

