/*
 * Decompiled with CFR 0.152.
 */
package cn.sec.file.local;

import cn.sec.file.BaseFileSystem;
import cn.sec.file.FileInfo;
import cn.sec.file.local.LocalFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileSystem;

public class LocalFileSystem
implements BaseFileSystem {
    public FileSystem fileSystem;

    @Override
    public void deleteFile(String file) throws IOException {
        new File(file).delete();
    }

    @Override
    public void mkdirs(String path) throws IOException {
        new File(path).mkdirs();
    }

    @Override
    public void create(String path) throws IOException {
        new File(path).createNewFile();
    }

    @Override
    public InputStream getInputStream(String file) throws IOException {
        return new FileInputStream(new File(file));
    }

    @Override
    public OutputStream getOutputStream(String file) throws IOException {
        return new FileOutputStream(new File(file));
    }

    @Override
    public boolean isFileExist(String hdfsPath) throws IOException {
        return new File(hdfsPath).isFile();
    }

    @Override
    public List<FileInfo> getDirFiles(String file) throws IOException {
        File[] files = new File(file).listFiles();
        return Stream.of(files).map(s -> LocalFileUtil.file2FileInfo(s, this)).collect(Collectors.toList());
    }

    @Override
    public FileInfo getFiles(String file) throws IOException {
        return LocalFileUtil.file2FileInfo(new File(file), this);
    }

    private FileSystem getFileSystem() {
        return this.fileSystem;
    }
}

