/*
 * Decompiled with CFR 0.152.
 */
package cn.sec.file.hdfs;

import cn.sec.file.BaseFileSystem;
import cn.sec.file.FileInfo;
import cn.sec.file.hdfs.HDFSFileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSFileSystem
implements BaseFileSystem {
    public FileSystem fileSystem;

    public HDFSFileSystem(Configuration conf) throws IOException {
        this.fileSystem = FileSystem.get((Configuration)conf);
    }

    @Override
    public void deleteFile(String file) throws IOException {
        FileSystem fs = null;
        fs = this.getFileSystem();
        Path path = new Path(file);
        fs.delete(path, true);
    }

    @Override
    public void mkdirs(String path) throws IOException {
        FileSystem fs = null;
        fs = this.getFileSystem();
        boolean fileExist = this.isFileExist(path);
        if (!fileExist) {
            fs.mkdirs(new Path(path));
        }
    }

    @Override
    public void create(String path) throws IOException {
        FileSystem fs = null;
        fs = this.getFileSystem();
        boolean fileExist = this.isFileExist(path);
        if (!fileExist) {
            fs.create(new Path(path));
        }
    }

    @Override
    public InputStream getInputStream(String file) throws IOException {
        Path path = new Path(file);
        return this.getFileSystem().open(path);
    }

    @Override
    public OutputStream getOutputStream(String file) throws IOException {
        Path path = new Path(file);
        return this.getFileSystem().create(path);
    }

    @Override
    public boolean isFileExist(String hdfsPath) throws IOException {
        FileSystem fs = null;
        fs = this.getFileSystem();
        Path pathSrc = new Path(hdfsPath);
        boolean result = fs.exists(pathSrc);
        return result;
    }

    @Override
    public List<FileInfo> getDirFiles(String file) throws IOException {
        Path pathSrc;
        FileStatus[] result = null;
        FileSystem fs = null;
        fs = this.getFileSystem();
        result = fs.listStatus(pathSrc = new Path(file));
        if (result == null || result.length == 0) {
            return new ArrayList<FileInfo>();
        }
        return Stream.of(result).map(s -> HDFSFileUtil.hdfs2FileInfo(s, this)).collect(Collectors.toList());
    }

    @Override
    public FileInfo getFiles(String file) throws IOException {
        FileSystem fs = null;
        fs = this.getFileSystem();
        Path pathSrc = new Path(file);
        FileStatus result = fs.getFileStatus(pathSrc);
        return HDFSFileUtil.hdfs2FileInfo(result, this);
    }

    private FileSystem getFileSystem() {
        return this.fileSystem;
    }
}

