/*
 * Decompiled with CFR 0.152.
 */
package cn.sec.file;

import cn.sec.file.FileInfo;
import cn.sec.file.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public interface BaseFileSystem {
    public void deleteFile(String var1) throws IOException;

    public void mkdirs(String var1) throws IOException;

    public void create(String var1) throws IOException;

    public InputStream getInputStream(String var1) throws IOException;

    public OutputStream getOutputStream(String var1) throws IOException;

    default public void uploadFile(FileInfo localPath, String file) throws IOException {
        try (OutputStream out = localPath.getOutputStream();
             InputStream in = this.getInputStream(file);){
            IOUtils.copyBytes(in, out, 1024);
        }
    }

    default public void downloadFile(String file, FileInfo localPath) throws IOException {
        try (InputStream in = localPath.getInputStream();
             OutputStream out = this.getOutputStream(file);){
            IOUtils.copyBytes(in, out, 1024);
        }
    }

    public boolean isFileExist(String var1) throws IOException;

    public List<FileInfo> getDirFiles(String var1) throws IOException;

    public FileInfo getFiles(String var1) throws IOException;
}

