/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.Valuable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Values {
    private static final ConcurrentMap<Class<?>, Class<?>> VALUE_TYPES = new ConcurrentHashMap();

    private Values() {
    }

    public static <T extends Valuable<V>, V> Class<V> getValueType(Class<T> type) {
        if (!Valuable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("type not is Valuable.");
        }
        return VALUE_TYPES.computeIfAbsent(type, key -> {
            Type valueType = Values.getValueTypeArgument(Values.getParentType(type));
            if (!(valueType instanceof Class)) {
                throw new IllegalStateException();
            }
            return (Class)valueType;
        });
    }

    private static Type getParentType(Class<?> type) {
        Type[] genericInterfaces;
        for (Type item : genericInterfaces = type.getGenericInterfaces()) {
            Class midClass;
            if (item instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)item).getRawType();
                if (!(rawType instanceof Class)) {
                    throw new IllegalStateException("");
                }
                midClass = (Class)rawType;
            } else if (item instanceof Class) {
                midClass = (Class)item;
            } else {
                throw new IllegalStateException();
            }
            if (!Valuable.class.isAssignableFrom(midClass)) continue;
            return item;
        }
        return type.getGenericSuperclass();
    }

    private static Type getValueTypeArgument(Type type) {
        if (type instanceof Class) {
            return Values.getValueTypeArgument((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return Values.getValueTypeArgument((ParameterizedType)type);
        }
        return null;
    }

    private static Type getValueTypeArgument(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            throw new IllegalStateException("");
        }
        if (rawType == Valuable.class) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        if (!Valuable.class.isAssignableFrom((Class)rawType)) {
            return null;
        }
        Type valueTypeArgument = Values.getValueTypeArgument(rawType);
        if (valueTypeArgument instanceof ParameterizedType) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        if (valueTypeArgument instanceof TypeVariable) {
            return Values.getValueTypeArgument(parameterizedType, (TypeVariable)valueTypeArgument);
        }
        if (valueTypeArgument instanceof Class) {
            return valueTypeArgument;
        }
        return null;
    }

    private static Type getValueTypeArgument(ParameterizedType parameterizedType, TypeVariable<?> typeVariable) {
        Class rawType = (Class)parameterizedType.getRawType();
        TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (typeParameters[i] != typeVariable) continue;
            return parameterizedType.getActualTypeArguments()[i];
        }
        return null;
    }

    private static Type getValueTypeArgument(Class<?> type) {
        if (!Valuable.class.isAssignableFrom(type)) {
            return null;
        }
        return Values.getValueTypeArgument(Values.getParentType(type));
    }

    private static Class<?> getRawType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        if (rawType instanceof Class) {
            return (Class)rawType;
        }
        throw new IllegalStateException("");
    }
}

