/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.AbstractFlag;
import cn.linjpxc.enumx.FlagValue;
import cn.linjpxc.enumx.Flags;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeSet;

public abstract class TextFlag<F extends TextFlag<F>>
extends AbstractFlag<F, String> {
    protected static final String DEFAULT_DELIMITER = "|";
    protected final String delimiter;
    protected final String splitDelimiter;

    protected TextFlag(String delimiter) {
        super("");
        if (delimiter.isEmpty()) {
            throw new IllegalArgumentException("Delimiter is empty.");
        }
        this.delimiter = delimiter;
        this.splitDelimiter = "\\" + delimiter;
    }

    protected TextFlag(String delimiter, String value) {
        super(TextFlag.handleValue(value, delimiter));
        if (delimiter.isEmpty()) {
            throw new IllegalArgumentException("Delimiter is empty.");
        }
        this.delimiter = delimiter;
        this.splitDelimiter = "\\" + delimiter;
    }

    protected TextFlag(String delimiter, String name, String value) {
        super(name, TextFlag.handleValue(value, delimiter));
        if (delimiter.isEmpty()) {
            throw new IllegalArgumentException("Delimiter is empty.");
        }
        this.delimiter = delimiter;
        this.splitDelimiter = "\\" + delimiter;
    }

    @Override
    protected Class<?> superClass() {
        return TextFlag.class;
    }

    @Override
    public String value() {
        if (((String)this.value).isEmpty()) {
            Flags.getFlagWrappers(this.getDeclaringClass());
        }
        return (String)super.value();
    }

    @Override
    public boolean hasValue(String value) {
        String[] valueArray;
        if (value == null) {
            return false;
        }
        if ((value = this.handleValue(value)).isEmpty()) {
            return this.hasEmpty();
        }
        String thisValue = this.value();
        if (thisValue.equalsIgnoreCase(value)) {
            return true;
        }
        String[] thisArray = thisValue.split(this.splitDelimiter);
        block0: for (String valueItem : valueArray = value.split(this.splitDelimiter)) {
            if ((valueItem = valueItem.trim()).isEmpty()) continue;
            for (String thisItem : thisArray) {
                if ((thisItem = thisItem.trim()).equalsIgnoreCase(valueItem)) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public F addValue(String value) {
        value = this.handleValue(value);
        String[] thisArray = this.value().split(this.splitDelimiter);
        String[] valueArray = value.split(this.splitDelimiter);
        StringBuilder builder = new StringBuilder((String)this.value);
        block0: for (String valueItem : valueArray) {
            if ((valueItem = valueItem.trim()).isEmpty()) continue;
            for (String thisItem : thisArray) {
                if (thisItem.equalsIgnoreCase(valueItem)) continue block0;
            }
            if (builder.length() > 0) {
                builder.append(this.delimiter);
            }
            builder.append(valueItem);
        }
        return (F)((TextFlag)this.createFlagRemoveNone(builder.toString()));
    }

    @Override
    public F removeValue(String value) {
        value = this.handleValue(value);
        String[] thisArray = this.value().split(this.splitDelimiter);
        String[] valueArray = value.split(this.splitDelimiter);
        StringBuilder builder = new StringBuilder();
        block0: for (String thisItem : thisArray) {
            for (String valueItem : valueArray) {
                if (!(valueItem = valueItem.trim()).isEmpty() && thisItem.equalsIgnoreCase(valueItem)) continue block0;
            }
            if (builder.length() > 0) {
                builder.append(this.delimiter);
            }
            builder.append(thisItem);
        }
        return (F)((TextFlag)this.createFlagRemoveNone(builder.toString()));
    }

    @Override
    public int compareTo(F o) {
        if (o == null) {
            return 1;
        }
        return ((String)this.value).compareTo((String)((TextFlag)o).value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FlagValue && this.getDeclaringClass() == ((FlagValue)obj).getDeclaringClass()) {
            TextFlag that = (TextFlag)obj;
            return this.value().equalsIgnoreCase(that.value());
        }
        return false;
    }

    @Override
    public String toString() {
        return Flags.toString(this, this.delimiter);
    }

    protected boolean hasEmpty() {
        return false;
    }

    protected final String handleValue(String value) {
        return TextFlag.handleValue(value, this.delimiter);
    }

    protected static String handleValue(String value, String delimiter) {
        if ((value = value.trim()).startsWith(delimiter)) {
            value = value.substring(1);
        }
        if (value.endsWith(delimiter)) {
            value = value.substring(0, value.length() - 1);
        }
        value = value.trim();
        String[] array = value.split("\\\\" + delimiter);
        TreeSet<String> set = new TreeSet<String>((o1, o2) -> {
            if (Objects.equals(o1, o2)) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            return o1.compareToIgnoreCase((String)o2);
        });
        StringBuilder builder = new StringBuilder();
        for (String item : array) {
            if (!set.add(item = item.trim())) continue;
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            builder.append(item);
        }
        return builder.toString().toUpperCase(Locale.ROOT);
    }
}

