/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.AbstractFlag;
import cn.linjpxc.enumx.ClassUtils;
import cn.linjpxc.enumx.Flag;
import cn.linjpxc.enumx.FlagValue;
import cn.linjpxc.enumx.FlagWrapper;
import cn.linjpxc.enumx.TextFlag;
import cn.linjpxc.enumx.Values;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class Flags {
    private static final String VALUE_OF_METHOD_NAME = "valueOf";
    private static final ConcurrentHashMap<Class<?>, List<FlagWrapper<?, ?>>> FLAG_WRAPPERS = new ConcurrentHashMap();

    private Flags() {
    }

    public static <F extends FlagValue<F, V>, V> Class<V> getValueType(Class<F> clazz) {
        return Values.getValueType(clazz);
    }

    public static <F extends FlagValue<F, V>, V> String toString(F flag) {
        return Flags.toString(flag, " | ");
    }

    public static <F extends FlagValue<F, V>, V> F[] getValues(Class<F> clazz) {
        return (FlagValue[])Flags.getFlagWrappers(clazz).stream().map(FlagWrapper::getValue).toArray(length -> (FlagValue[])Array.newInstance(clazz, length));
    }

    public static <F extends FlagValue<F, V>, V> F[] getDefineValues(Class<F> clazz) {
        return (FlagValue[])Flags.getFlagWrappers(clazz).stream().filter(item -> item.getFlag().isDefined()).map(FlagWrapper::getValue).toArray(length -> (FlagValue[])Array.newInstance(clazz, length));
    }

    public static <F extends FlagValue<F, V>, V> F valueOf(Class<F> clazz, Object value, boolean primitiveConvert) {
        Class<V> valueType;
        if (value == null) {
            return null;
        }
        if (primitiveConvert && (valueType = Flags.getValueType(clazz)) != value) {
            return Flags.valueOf(clazz, ClassUtils.convertPrimitive(valueType, value));
        }
        return Flags.valueOf(clazz, value);
    }

    static <F extends FlagValue<F, V>, V> F valueOf(Class<F> clazz, V value) {
        List<FlagWrapper<F, V>> list = Flags.getFlagWrappers(clazz);
        for (FlagWrapper<F, V> item : list) {
            if (!Objects.equals(item.getValue().value(), value)) continue;
            return (F)item.getValue();
        }
        Class<V> valueType = Flags.getValueType(clazz);
        try {
            Method valueOfMethod = Flags.getValueOfMethod(clazz, valueType);
            valueOfMethod.setAccessible(true);
            return (F)((FlagValue)valueOfMethod.invoke(null, value.toString(), value));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static <F extends FlagValue<F, V>, V> String toString(F flag, String delimiter) {
        FlagValue[] values;
        if (flag.isDefined()) {
            return flag.name();
        }
        for (FlagValue value : values = Flags.getValues(flag.getDeclaringClass())) {
            if (!value.equals(flag)) continue;
            return flag.name();
        }
        StringBuilder builder = new StringBuilder();
        Object f = null;
        for (FlagValue value : values) {
            if (!flag.hasFlag((FlagValue)value)) continue;
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            builder.append(value.name());
            f = f == null ? value : f.addFlag(value);
            if (f.compareTo(flag) >= 0) break;
        }
        if (f != null && !f.equals(flag)) {
            return flag.name();
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return flag.name();
    }

    static <F extends FlagValue<F, V>, V> List<FlagWrapper<F, V>> getFlagWrappers(Class<F> clazz) {
        if (!FlagValue.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("Not is FlagValue class.");
        }
        return FLAG_WRAPPERS.computeIfAbsent(clazz, key -> {
            try {
                Field[] fields = clazz.getDeclaredFields();
                ArrayList list = new ArrayList();
                for (Field field : fields) {
                    Flag flag = field.getDeclaredAnnotation(Flag.class);
                    if (flag == null) continue;
                    if (!Modifier.isStatic(field.getModifiers())) {
                        System.err.printf("%s the field is not static: %s%n", clazz, field.getName());
                        continue;
                    }
                    field.setAccessible(true);
                    FlagValue value = (FlagValue)field.get(null);
                    if (value instanceof TextFlag) {
                        Field valueField = AbstractFlag.class.getDeclaredField("value");
                        valueField.setAccessible(true);
                        String tmp = (String)valueField.get(value);
                        if (tmp.isEmpty()) {
                            Flags.removeFinal(valueField);
                            valueField.set(value, field.getName().toUpperCase(Locale.ROOT));
                        }
                    }
                    list.add(new FlagWrapper(flag, field.getName(), value));
                }
                return list;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void removeFinal(Field field) {
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Method getValueOfMethod(Class<?> clazz, Class<?> valueType) throws NoSuchMethodException {
        Class<?> primitiveType = ClassUtils.convertPrimitiveType(valueType);
        if (primitiveType != valueType) {
            try {
                return clazz.getDeclaredMethod(VALUE_OF_METHOD_NAME, String.class, primitiveType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clazz.getDeclaredMethod(VALUE_OF_METHOD_NAME, String.class, valueType);
    }
}

