/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.FlagWrapper;
import cn.linjpxc.enumx.Flags;
import cn.linjpxc.enumx.Valuable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface FlagValue<F extends FlagValue<F, V>, V>
extends Valuable<V>,
Comparable<F> {
    default public String name() {
        List list = Flags.getFlagWrappers(this.getDeclaringClass());
        for (FlagWrapper item : list) {
            if (!item.getValue().equals(this)) continue;
            return item.getName();
        }
        return this.value().toString();
    }

    default public boolean isDefined() {
        List list = Flags.getFlagWrappers(this.getDeclaringClass());
        for (FlagWrapper item : list) {
            if (!item.getValue().equals(this)) continue;
            return item.getFlag().isDefined();
        }
        return false;
    }

    default public boolean hasFlag(F flag) {
        if (flag == null) {
            return false;
        }
        return this.hasValue(flag.value());
    }

    public boolean hasValue(V var1);

    default public F addFlag(F flag) {
        return this.addValue(flag.value());
    }

    public F addValue(V var1);

    default public F removeFlag(F flag) {
        return this.removeValue(flag.value());
    }

    public F removeValue(V var1);

    public Class<F> getDeclaringClass();

    default public F[] toDefineArray() {
        return this.toDefineArray(false);
    }

    default public F[] toDefineArray(boolean withOther) {
        List<F> list = this.toDefineFlags(withOther);
        FlagValue[] arr = (FlagValue[])Array.newInstance(this.getDeclaringClass(), 0);
        if (list.isEmpty()) {
            return arr;
        }
        return list.toArray(arr);
    }

    default public List<F> toDefineFlags() {
        return this.toDefineFlags(false);
    }

    default public List<F> toDefineFlags(boolean withOther) {
        Class<F> declaringClass = this.getDeclaringClass();
        FlagValue[] defineValues = Flags.getDefineValues(declaringClass);
        ArrayList<FlagValue> list = new ArrayList<FlagValue>();
        FlagValue f = null;
        for (FlagValue item : defineValues) {
            if (!this.hasFlag(item)) continue;
            list.add(item);
            f = f == null ? item : f.addFlag(item);
        }
        if (withOther && !this.equals(f)) {
            if (f == null) {
                list.add(this);
            } else {
                list.add(this.removeFlag(f));
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static <F extends FlagValue<F, V>, V> F valueOf(Class<F> clazz, V value) {
        return Flags.valueOf(clazz, value);
    }

    public static <F extends FlagValue<F, V>, V> int compare(F left, F right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        return left.compareTo(right);
    }
}

