/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.ClassUtils;
import cn.linjpxc.enumx.StringUtils;
import cn.linjpxc.enumx.Valuable;
import cn.linjpxc.enumx.Values;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Enums {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    private Enums() {
    }

    public static <E extends Enum<E>, V> Class<V> getValueType(Class<E> clazz) {
        return Values.getValueType(clazz);
    }

    public static <E extends Enum<E>, V> E valueOf(Class<E> enumType, Object value) {
        return Enums.valueOf(enumType, value, false);
    }

    public static <E extends Enum<E>, V> E valueOf(Class<E> enumType, Class<V> valueType, Object value) {
        return Enums.valueOf(enumType, valueType, value, false);
    }

    public static <E extends Enum<E>, V> E valueOf(Class<E> enumType, Object value, boolean primitiveConvert) {
        return Enums.valueOf(enumType, Enums.getValueType(enumType), value, primitiveConvert);
    }

    public static <E extends Enum<E>, V> E valueOf(Class<E> enumType, Class<V> valueType, Object value, boolean primitiveConvert) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        if (Enums.isPrimitiveOrEnumValueType(valueType, primitiveConvert, value)) {
            Object primitiveValue = Enums.convertPrimitive(valueType, value, primitiveConvert);
            for (Enum item : enumConstants) {
                if (((Valuable)((Object)item)).value().equals(value)) {
                    return (E)item;
                }
                if (primitiveValue == null || !primitiveValue.equals(((Valuable)((Object)item)).value())) continue;
                return (E)item;
            }
        }
        String name = value.toString();
        for (Enum item : enumConstants) {
            if (item.name().equals(name)) {
                return (E)item;
            }
            if (!item.name().equalsIgnoreCase(name)) continue;
            return (E)item;
        }
        throw new IllegalArgumentException("No enum constant " + enumType.getCanonicalName() + "." + name);
    }

    public static <E extends Enum<E>> E valueOfIgnoreCase(Class<E> enumType, String name) {
        Enum[] values;
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException("class not enum.");
        }
        for (Enum item : values = (Enum[])enumType.getEnumConstants()) {
            if (!item.name().equalsIgnoreCase(name)) continue;
            return (E)item;
        }
        throw new IllegalArgumentException("No enum constant " + enumType.getCanonicalName() + "." + name);
    }

    public static <E extends Enum<E>> boolean exists(Class<E> enumType, String name) {
        Enum[] enumConstants;
        if (StringUtils.isBlank(name)) {
            return false;
        }
        for (Enum item : enumConstants = (Enum[])enumType.getEnumConstants()) {
            if (!item.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static <E extends Enum<E>> boolean existsIgnoreCase(Class<E> enumType, String name) {
        Enum[] enumConstants;
        if (StringUtils.isBlank(name)) {
            return false;
        }
        for (Enum item : enumConstants = (Enum[])enumType.getEnumConstants()) {
            if (!item.name().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static <E extends Enum<E>, V> boolean exists(Class<E> enumType, V value) {
        Enum[] enumConstants;
        for (Enum item : enumConstants = (Enum[])enumType.getEnumConstants()) {
            if (!((Valuable)((Object)item)).value().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static <E extends Enum<E>> List<E> list(Class<E> enumType) {
        return new ArrayList<E>(Arrays.asList(enumType.getEnumConstants()));
    }

    public static <E extends Enum<E>> Map<String, E> map(Class<E> enumType) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        HashMap<String, Enum> map = new HashMap<String, Enum>(enumConstants.length);
        for (Enum item : enumConstants) {
            map.put(item.name(), item);
        }
        return map;
    }

    public static <E extends Enum<E>, V> Map<V, E> valueMap(Class<E> enumType) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        HashMap map = new HashMap(enumConstants.length);
        for (Enum enumConstant : enumConstants) {
            map.put(((Valuable)((Object)enumConstant)).value(), enumConstant);
        }
        return map;
    }

    private static boolean isPrimitiveOrEnumValueType(Class<?> valueType, boolean primitiveConvert, Object value) {
        return ClassUtils.isPrimitiveWrapper(valueType) && primitiveConvert || valueType == value.getClass() || valueType.isAssignableFrom(value.getClass());
    }

    private static Object convertPrimitive(Class<?> clazz, Object value, boolean primitiveConvert) {
        if (!primitiveConvert) {
            return null;
        }
        try {
            return ClassUtils.convertPrimitive(clazz, value);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

