/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.FlagValue;
import cn.linjpxc.enumx.Flags;
import java.util.Objects;

public abstract class AbstractFlag<F extends AbstractFlag<F, V>, V>
implements FlagValue<F, V> {
    private static final long serialVersionUID = 8938203086618420260L;
    private final String name;
    protected final V value;

    protected AbstractFlag(V value) {
        this(null, value);
    }

    protected AbstractFlag(String name, V value) {
        this.name = name;
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public String name() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        return FlagValue.super.name();
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public final Class<F> getDeclaringClass() {
        Class<?> clazz = this.getClass();
        Class<?> zuper = clazz.getSuperclass();
        return zuper == this.superClass() ? clazz : zuper;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FlagValue && this.getDeclaringClass() == ((FlagValue)obj).getDeclaringClass()) {
            AbstractFlag that = (AbstractFlag)obj;
            return Objects.equals(this.value(), that.value());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.value());
    }

    public String toString() {
        return Flags.toString(this);
    }

    protected F noneFlag() {
        return null;
    }

    protected F createFlagRemoveNone(V value) {
        F flag = this.createFlag(value);
        F noneFlag = this.noneFlag();
        if (noneFlag == null || ((AbstractFlag)flag).equals(noneFlag) || !flag.hasFlag(this.noneFlag())) {
            return flag;
        }
        return (F)((AbstractFlag)flag.removeFlag(noneFlag));
    }

    protected abstract F createFlag(V var1);

    protected abstract Class<?> superClass();
}

