/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.AbstractFlag;
import cn.linjpxc.enumx.Flag;
import cn.linjpxc.enumx.FlagValue;
import cn.linjpxc.enumx.FlagWrapper;
import cn.linjpxc.enumx.TextFlag;
import cn.linjpxc.enumx.Values;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public final class Flags {
    private static final ConcurrentHashMap<Class<?>, List<FlagWrapper<?, ?>>> FLAG_WRAPPERS = new ConcurrentHashMap();

    private Flags() {
    }

    public static <F extends FlagValue<F, V>, V> Class<V> getValueType(Class<F> clazz) {
        return Values.getValueType(clazz);
    }

    public static <F extends FlagValue<F, V>, V> String toString(F flag) {
        return Flags.toString(flag, " | ");
    }

    static <F extends FlagValue<F, V>, V> String toString(F flag, String delimiter) {
        FlagValue[] values;
        for (FlagValue value : values = Flags.getValues(flag.getDeclaringClass())) {
            if (!value.equals(flag)) continue;
            return flag.name();
        }
        StringBuilder builder = new StringBuilder();
        Object f = null;
        for (FlagValue value : values) {
            if (!flag.hasFlag((FlagValue)value)) continue;
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            builder.append(value.name());
            f = f == null ? value : f.addFlag(value);
            if (f.compareTo(flag) >= 0) break;
        }
        if (f != null && !f.equals(flag)) {
            return flag.name();
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return flag.name();
    }

    public static <F extends FlagValue<F, V>, V> F[] getValues(Class<F> clazz) {
        return (FlagValue[])Flags.getFlagWrappers(clazz).stream().map(FlagWrapper::getValue).toArray(length -> (FlagValue[])Array.newInstance(clazz, length));
    }

    public static <F extends FlagValue<F, V>, V> F[] getDefineValues(Class<F> clazz) {
        return (FlagValue[])Flags.getFlagWrappers(clazz).stream().filter(item -> item.getFlag().isDefined()).map(FlagWrapper::getValue).toArray(length -> (FlagValue[])Array.newInstance(clazz, length));
    }

    static <F extends FlagValue<F, V>, V> List<FlagWrapper<F, V>> getFlagWrappers(Class<F> clazz) {
        if (!FlagValue.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("Not is FlagValue class.");
        }
        return FLAG_WRAPPERS.computeIfAbsent(clazz, key -> {
            try {
                Field[] fields = clazz.getDeclaredFields();
                ArrayList list = new ArrayList();
                for (Field field : fields) {
                    Flag flag = field.getDeclaredAnnotation(Flag.class);
                    if (flag == null) continue;
                    if (!Modifier.isStatic(field.getModifiers())) {
                        System.err.printf("%s the field is not static: %s%n", clazz, field.getName());
                        continue;
                    }
                    field.setAccessible(true);
                    FlagValue value = (FlagValue)field.get(null);
                    if (value instanceof TextFlag) {
                        Field valueField = AbstractFlag.class.getDeclaredField("value");
                        valueField.setAccessible(true);
                        String tmp = (String)valueField.get(value);
                        if (tmp.length() < 1) {
                            Field modifiersField = Field.class.getDeclaredField("modifiers");
                            modifiersField.setAccessible(true);
                            modifiersField.setInt(valueField, valueField.getModifiers() & 0xFFFFFFEF);
                            valueField.set(value, field.getName().toUpperCase(Locale.ROOT));
                        }
                    }
                    list.add(new FlagWrapper(flag, field.getName(), value));
                }
                return list;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

