/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.FlagWrapper;
import cn.linjpxc.enumx.Flags;
import cn.linjpxc.enumx.Valuable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public interface FlagValue<F extends FlagValue<F, V>, V>
extends Valuable<V>,
Comparable<F> {
    default public String name() {
        List list = Flags.getFlagWrappers(this.getDeclaringClass());
        for (FlagWrapper item : list) {
            if (!item.getValue().equals(this)) continue;
            return item.getName();
        }
        return this.value().toString();
    }

    default public boolean isDefined() {
        List list = Flags.getFlagWrappers(this.getDeclaringClass());
        for (FlagWrapper item : list) {
            if (!item.getValue().equals(this)) continue;
            return item.getFlag().isDefined();
        }
        return false;
    }

    default public boolean hasFlag(F flag) {
        if (flag == null) {
            return false;
        }
        return this.hasValue(flag.value());
    }

    public boolean hasValue(V var1);

    default public F addFlag(F flag) {
        return this.addValue(flag.value());
    }

    public F addValue(V var1);

    default public F removeFlag(F flag) {
        return this.removeValue(flag.value());
    }

    public F removeValue(V var1);

    public Class<F> getDeclaringClass();

    public static <F extends FlagValue<F, V>, V> F valueOf(Class<F> clazz, V value) {
        List list = Flags.getFlagWrappers(clazz);
        for (FlagWrapper item : list) {
            if (!Objects.equals(item.getValue().value(), value)) continue;
            return (F)item.getValue();
        }
        try {
            Method valueOfMethod = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> Modifier.isStatic(method.getModifiers()) && method.getName().equals("valueOf")).findFirst().orElse(null);
            if (valueOfMethod == null) {
                throw new RuntimeException();
            }
            valueOfMethod.setAccessible(true);
            return (F)((FlagValue)valueOfMethod.invoke(null, value));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <F extends FlagValue<F, V>, V> int compare(F left, F right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        return left.compareTo(right);
    }
}

