/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.Enums;
import cn.linjpxc.enumx.Flag;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.reflect.ConstructorAccessor;
import sun.reflect.FieldAccessor;
import sun.reflect.ReflectionFactory;

public final class Flags {
    private static final ReflectionFactory REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();
    private static final ConcurrentMap<Class<?>, ConcurrentMap<Object, Flag<?, ?>>> FLAG_MAP = new ConcurrentHashMap();

    private Flags() {
    }

    static <F extends Enum<F>, V> F valueOf(Class<F> flagType, V value) {
        return (F)FLAG_MAP.computeIfAbsent(flagType, clazz -> {
            if (!clazz.isEnum()) {
                throw new IllegalArgumentException("not enum class.");
            }
            if (!Flag.class.isAssignableFrom((Class<?>)clazz)) {
                throw new IllegalArgumentException("not flag class.");
            }
            return new ConcurrentHashMap(Enums.valueMap(flagType));
        }).computeIfAbsent(value, v -> {
            try {
                Constructor<?>[] constructors = flagType.getDeclaredConstructors();
                if (constructors.length != 1) {
                    throw new RuntimeException("Too many constructors.");
                }
                return Flags.addFlag(flagType, value.toString(), new Class[]{constructors[0].getParameterTypes()[2]}, new Object[]{value});
            }
            catch (Exception e) {
                throw new IllegalArgumentException("No flag constant " + flagType.getCanonicalName() + " value: " + value, e);
            }
        });
    }

    static <T extends Enum<T>> T addFlag(Class<T> enumType, String enumName, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Field[] fields;
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            if (!field.getName().contains("$VALUES")) continue;
            valuesField = field;
            break;
        }
        if (valuesField == null) {
            throw new IllegalArgumentException();
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        Enum[] previousValues = (Enum[])valuesField.get(enumType);
        ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
        Enum newValue = (Enum)Flags.makeEnum(enumType, enumName, values.size(), additionalTypes, additionalValues);
        values.add(newValue);
        Flags.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
        Flags.cleanEnumCache(enumType);
        return (T)newValue;
    }

    private static void setFailsafeFieldValue(Field field, Object target, Object value) throws NoSuchFieldException, IllegalAccessException {
        Flags.setAccessible(field, true);
        int modifiers = field.getModifiers();
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        Flags.setAccessible(modifiersField, true);
        modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
        FieldAccessor fieldAccessor = REFLECTION_FACTORY.newFieldAccessor(field, false);
        fieldAccessor.set(target, value);
    }

    private static void blankField(Class<? extends Enum<?>> enumClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field[] declaredFields;
        for (Field field : declaredFields = Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            AccessibleObject.setAccessible(new Field[]{field}, true);
            Flags.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<? extends Enum<?>> enumClass) throws NoSuchFieldException, IllegalAccessException {
        Flags.blankField(enumClass, "enumConstantDirectory");
        Flags.blankField(enumClass, "enumConstants");
    }

    private static ConstructorAccessor getConstructorAccessor(Class<? extends Enum<?>> enumClass, Class<?>[] additionalParameterTypes) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return REFLECTION_FACTORY.newConstructorAccessor(enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static Object makeEnum(Class<? extends Enum<?>> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws NoSuchMethodException, InvocationTargetException, InstantiationException {
        Object[] params = new Object[additionalValues.length + 2];
        params[0] = value;
        params[1] = ordinal;
        System.arraycopy(additionalValues, 0, params, 2, additionalValues.length);
        return enumClass.cast(Flags.getConstructorAccessor(enumClass, additionalTypes).newInstance(params));
    }

    private static void setAccessible(AccessibleObject accessible, boolean value) {
        AccessController.doPrivileged(() -> {
            accessible.setAccessible(value);
            return null;
        });
    }
}

