/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.Valuable;
import java.util.Objects;

public interface EnumValue<E extends Enum<E>, V>
extends Valuable<V> {
    public Class<E> getDeclaringClass();

    public static <E extends Enum<E>, V> E valueOf(Class<E> enumType, V value) {
        Enum[] values;
        Objects.requireNonNull(value, "Value is null");
        for (Enum item : values = (Enum[])enumType.getEnumConstants()) {
            if (!Objects.equals(((Valuable)((Object)item)).value(), value)) continue;
            return (E)item;
        }
        throw new IllegalArgumentException("No enum constant " + enumType.getCanonicalName() + " value: " + value);
    }

    public static <E extends Enum<E>, V> int compare(E left, E right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        try {
            Class<?> valueType = left.getClass().getDeclaredMethod("value", new Class[0]).getReturnType();
            if (Comparable.class.isAssignableFrom(valueType)) {
                Comparable comparable = (Comparable)((Valuable)((Object)left)).value();
                return comparable.compareTo(((Valuable)((Object)right)).value());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return left.compareTo(right);
    }
}

