/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumx;

import cn.linjpxc.enumx.EnumValue;
import cn.linjpxc.enumx.Flags;
import java.lang.reflect.Array;
import java.util.ArrayList;

public interface Flag<F extends Enum<F>, V>
extends EnumValue<F, V> {
    default public boolean isDefined() {
        if (this instanceof Enum) {
            Enum e = (Enum)((Object)this);
            return !this.value().toString().equals(e.name());
        }
        return false;
    }

    public boolean hasFlag(F var1);

    public F addFlag(F var1);

    public F removeFlag(F var1);

    public static <F extends Enum<F>, V> F valueOf(Class<F> flagType, V value) {
        return Flags.valueOf(flagType, value);
    }

    public static <F extends Enum<F>, V> F[] definedValues(Class<F> flagClass) {
        ArrayList<Enum> list = new ArrayList<Enum>();
        for (Enum item : (Enum[])flagClass.getEnumConstants()) {
            if (!((Flag)((Object)item)).isDefined()) continue;
            list.add(item);
        }
        return list.toArray((Enum[])Array.newInstance(flagClass, 0));
    }

    public static <F extends Enum<F>, V> String toString(F flag) {
        if (((Flag)((Object)flag)).isDefined()) {
            return flag.name();
        }
        Enum[] values = (Enum[])flag.getClass().getEnumConstants();
        StringBuilder builder = new StringBuilder();
        Enum f = null;
        for (Enum value : values) {
            if (!((Flag)((Object)value)).isDefined() || !((Flag)((Object)flag)).hasFlag(value)) continue;
            if (builder.length() > 0) {
                builder.append(" | ");
            }
            builder.append(value.name());
            f = f == null ? value : ((Flag)((Object)f)).addFlag(value);
            if (f != null && f.compareTo(flag) >= 0) break;
        }
        if (f == null || f != flag) {
            return flag.name();
        }
        return builder.toString();
    }
}

