/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumex;

import cn.linjpxc.enumex.FlagValue;
import java.util.Objects;

public final class LongFlagValue
extends FlagValue<LongFlagValue, Long> {
    private static final long serialVersionUID = 9040488892676722299L;
    private final long value;

    private LongFlagValue(long value) {
        this.value = value;
    }

    @Override
    public LongFlagValue and(LongFlagValue value) {
        return new LongFlagValue(this.value & value.value);
    }

    @Override
    public LongFlagValue or(LongFlagValue value) {
        return new LongFlagValue(this.value | value.value);
    }

    @Override
    public LongFlagValue not() {
        return new LongFlagValue(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Long value() {
        return this.value;
    }

    @Override
    public int compareTo(LongFlagValue o) {
        return Long.compare(this.value, o.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongFlagValue that = (LongFlagValue)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public String toBitString() {
        return Long.toBinaryString(this.value);
    }

    public static LongFlagValue valueOf(long value) {
        return new LongFlagValue(value);
    }

    public static int compare(LongFlagValue left, LongFlagValue right) {
        return FlagValue.compare(left, right);
    }
}

