/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumex;

import cn.linjpxc.enumex.BigFlag;
import cn.linjpxc.enumex.Flag;
import cn.linjpxc.enumex.IntFlag;
import cn.linjpxc.enumex.LongFlag;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import sun.reflect.ConstructorAccessor;
import sun.reflect.FieldAccessor;
import sun.reflect.ReflectionFactory;

final class FlagUtil {
    private static final ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();

    private FlagUtil() {
    }

    static Class<?> getFlagValueClass(Class<? extends Flag<?, ?, ?>> clazz, boolean isPrimitive) {
        if (IntFlag.class.isAssignableFrom(clazz)) {
            return isPrimitive ? Integer.TYPE : Integer.class;
        }
        if (LongFlag.class.isAssignableFrom(clazz)) {
            return isPrimitive ? Long.TYPE : Long.class;
        }
        if (BigFlag.class.isAssignableFrom(clazz)) {
            return BigInteger.class;
        }
        throw new IllegalArgumentException();
    }

    static <T extends Enum<T>> T addFlag(Class<T> enumType, String enumName, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Field[] fields;
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            if (!field.getName().contains("$VALUES")) continue;
            valuesField = field;
            break;
        }
        if (valuesField == null) {
            throw new IllegalArgumentException();
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        Enum[] previousValues = (Enum[])valuesField.get(enumType);
        ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
        Enum newValue = (Enum)FlagUtil.makeEnum(enumType, enumName, values.size(), additionalTypes, additionalValues);
        values.add(newValue);
        FlagUtil.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
        FlagUtil.cleanEnumCache(enumType);
        return (T)newValue;
    }

    private static void setFailsafeFieldValue(Field field, Object target, Object value) throws NoSuchFieldException, IllegalAccessException {
        FlagUtil.setAccessible(field, true);
        int modifiers = field.getModifiers();
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        FlagUtil.setAccessible(modifiersField, true);
        modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
        FieldAccessor fieldAccessor = reflectionFactory.newFieldAccessor(field, false);
        fieldAccessor.set(target, value);
    }

    private static void blankField(Class<? extends Enum<?>> enumClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field[] declaredFields;
        for (Field field : declaredFields = Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            AccessibleObject.setAccessible(new Field[]{field}, true);
            FlagUtil.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<? extends Enum<?>> enumClass) throws NoSuchFieldException, IllegalAccessException {
        FlagUtil.blankField(enumClass, "enumConstantDirectory");
        FlagUtil.blankField(enumClass, "enumConstants");
    }

    private static ConstructorAccessor getConstructorAccessor(Class<? extends Enum<?>> enumClass, Class<?>[] additionalParameterTypes) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return reflectionFactory.newConstructorAccessor(enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static Object makeEnum(Class<? extends Enum<?>> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws NoSuchMethodException, InvocationTargetException, InstantiationException {
        Object[] params = new Object[additionalValues.length + 2];
        params[0] = value;
        params[1] = ordinal;
        System.arraycopy(additionalValues, 0, params, 2, additionalValues.length);
        return enumClass.cast(FlagUtil.getConstructorAccessor(enumClass, additionalTypes).newInstance(params));
    }

    private static void setAccessible(AccessibleObject accessible, boolean value) {
        AccessController.doPrivileged(() -> {
            accessible.setAccessible(value);
            return null;
        });
    }
}

