/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumex;

import cn.linjpxc.enumex.FlagUtil;
import cn.linjpxc.enumex.FlagValue;
import cn.linjpxc.enumex.Valuable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public interface Flag<F extends Enum<F>, FV extends FlagValue<FV, V>, V extends Number>
extends Valuable<V> {
    public FV flagValue();

    @Override
    default public V value() {
        return (V)((Number)this.flagValue().value());
    }

    default public boolean isDefined() {
        if (this instanceof Enum) {
            Enum e = (Enum)((Object)this);
            return !this.value().toString().equals(e.name());
        }
        return false;
    }

    default public boolean hasFlag(F flag) {
        return ((FlagValue)this.flagValue()).and(((Flag)flag).flagValue()).equals(((Flag)flag).flagValue());
    }

    default public F addFlag(F flag) {
        return (F)Flag.valueOf(this.getClass(), ((FlagValue)this.flagValue()).or(((Flag)flag).flagValue()));
    }

    default public F removeFlag(F flag) {
        return (F)Flag.valueOf(this.getClass(), ((FlagValue)this.flagValue()).andNot(((Flag)flag).flagValue()));
    }

    public static <F extends Enum<F>, FV extends FlagValue<FV, V>, V extends Number> F valueOf(Class<F> flagClass, V value) {
        Enum[] values;
        for (Enum f : values = (Enum[])flagClass.getEnumConstants()) {
            if (!((Flag)((Object)f)).value().equals(value)) continue;
            return (F)f;
        }
        try {
            Constructor<?>[] constructors;
            boolean isPrimitive = false;
            for (Constructor<?> constructor : constructors = flagClass.getDeclaredConstructors()) {
                if (!constructor.getParameterTypes()[2].isPrimitive()) continue;
                isPrimitive = true;
                break;
            }
            return FlagUtil.addFlag(flagClass, value.toString(), new Class[]{FlagUtil.getFlagValueClass(flagClass, isPrimitive)}, new Object[]{value});
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No flag constant " + flagClass.getCanonicalName() + " value: " + value, e);
        }
    }

    public static <F extends Enum<F>, FV extends FlagValue<FV, V>, V extends Number> F valueOf(Class<F> flagClass, FV value) {
        return Flag.valueOf(flagClass, (Number)value.value());
    }

    public static <F extends Enum<F>, FV extends FlagValue<FV, V>, V extends Number> F[] definedValues(Class<F> flagClass) {
        ArrayList<Enum> list = new ArrayList<Enum>();
        for (Enum item : (Enum[])flagClass.getEnumConstants()) {
            if (!((Flag)((Object)item)).isDefined()) continue;
            list.add(item);
        }
        return list.toArray((Enum[])Array.newInstance(flagClass, 0));
    }

    public static <F extends Enum<F>, FV extends FlagValue<FV, V>, V extends Number> String toString(F flag) {
        if (((Flag)((Object)flag)).isDefined()) {
            return flag.name();
        }
        Enum[] values = (Enum[])flag.getClass().getEnumConstants();
        StringBuilder builder = new StringBuilder();
        Enum f = null;
        for (Enum value : values) {
            if (!((Flag)((Object)value)).isDefined() || !((Flag)((Object)flag)).hasFlag(value)) continue;
            if (builder.length() > 0) {
                builder.append(" | ");
            }
            builder.append(value.name());
            f = f == null ? value : ((Flag)((Object)f)).addFlag(value);
            if (f != null && f.compareTo(flag) >= 0) break;
        }
        if (f == null || f != flag) {
            return flag.name();
        }
        return builder.toString();
    }
}

