/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumex;

import cn.linjpxc.enumex.Valuable;
import java.util.Objects;

public interface EnumValue<E extends Enum<E>, V>
extends Valuable<V> {
    @Override
    public V value();

    public Class<E> getDeclaringClass();

    public static <E extends Enum<E>, V> E valueOf(Class<E> enumType, V value) {
        Enum[] values;
        Objects.requireNonNull(value, "Value is null");
        for (Enum item : values = (Enum[])enumType.getEnumConstants()) {
            if (!Objects.equals(((EnumValue)((Object)item)).value(), value)) continue;
            return (E)item;
        }
        throw new IllegalArgumentException("No enum constant " + enumType.getCanonicalName() + " value: " + value);
    }
}

