/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumex;

import cn.linjpxc.enumex.FlagValue;
import java.math.BigInteger;
import java.util.Objects;

public final class BigFlagValue
extends FlagValue<BigFlagValue, BigInteger> {
    private static final long serialVersionUID = 8250762746504008464L;
    private final BigInteger value;

    private BigFlagValue(BigInteger value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public BigFlagValue and(BigFlagValue value) {
        return new BigFlagValue(this.value.and(value.value));
    }

    @Override
    public BigFlagValue or(BigFlagValue value) {
        return new BigFlagValue(this.value.or(value.value));
    }

    @Override
    public BigFlagValue not() {
        return new BigFlagValue(this.value.not());
    }

    @Override
    public String toBitString() {
        return this.value.toString(2);
    }

    @Override
    public BigInteger value() {
        return this.value;
    }

    @Override
    public int compareTo(BigFlagValue o) {
        return this.value.compareTo(o.value);
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigFlagValue that = (BigFlagValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static BigFlagValue valueOf(BigInteger value) {
        return new BigFlagValue(value);
    }

    public static int compare(BigFlagValue left, BigFlagValue right) {
        return FlagValue.compare(left, right);
    }
}

