/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumex;

import cn.linjpxc.enumex.FlagValue;
import java.util.Objects;

public final class IntFlagValue
extends FlagValue<IntFlagValue, Integer> {
    private static final long serialVersionUID = 8520111187062580219L;
    private final int value;

    private IntFlagValue(int value) {
        this.value = value;
    }

    @Override
    public IntFlagValue and(IntFlagValue value) {
        return new IntFlagValue(this.value & value.value);
    }

    @Override
    public IntFlagValue or(IntFlagValue value) {
        return new IntFlagValue(this.value | value.value);
    }

    @Override
    public IntFlagValue not() {
        return new IntFlagValue(~this.value);
    }

    @Override
    public Integer value() {
        return this.value;
    }

    @Override
    public int compareTo(IntFlagValue o) {
        return Integer.compare(this.value, o.value);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntFlagValue that = (IntFlagValue)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public String toBitString() {
        return Integer.toBinaryString(this.value);
    }

    public static IntFlagValue valueOf(int value) {
        return new IntFlagValue(value);
    }

    public static int compare(IntFlagValue left, IntFlagValue right) {
        return FlagValue.compare(left, right);
    }
}

