/*
 * Decompiled with CFR 0.152.
 */
package cn.linjpxc.enumex;

import cn.linjpxc.enumex.Enum;
import cn.linjpxc.enumex.EnumValue;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

class EnumAnnotationProcessorHider {
    EnumAnnotationProcessorHider() {
    }

    @SupportedSourceVersion(value=SourceVersion.RELEASE_8)
    @SupportedAnnotationTypes(value={"cn.linjpxc.enumex.Enum"})
    public static class EnumProcessor
    extends AbstractProcessor {
        private static final String ENUM_VALUE_CLASS_NAME = EnumValue.class.getName();
        private static final String ENUM_VALUE_METHOD_NAME = "value";
        private static final String VALUE_OF_METHOD_NAME = "valueOf";
        private static final String VALUE_TYPE_CLASS_NAME = "valueType";
        private static final String JAVA_STRING_CLASS_NAME = "java.lang.String";

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            if (!(this.processingEnv instanceof JavacProcessingEnvironment)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "ProcessingEnvironment not is JavacProcessingEnvironment");
                return true;
            }
            Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
            Elements elementUtils = this.processingEnv.getElementUtils();
            final TreeMaker treeMaker = TreeMaker.instance(context);
            final JavacTrees javacTrees = JavacTrees.instance(this.processingEnv);
            Names names = Names.instance(context);
            final TypeElement enumValueTypeElement = elementUtils.getTypeElement(ENUM_VALUE_CLASS_NAME);
            roundEnv.getElementsAnnotatedWith(Enum.class).forEach(element -> {
                JCTree jcTree = javacTrees.getTree((Element)element);
                if (jcTree.getKind() == Tree.Kind.ENUM) {
                    TypeElement valueTypeElement = EnumProcessor.getEnumValueType(element, elementUtils, names);
                    if (valueTypeElement == null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Not found enum value type.");
                        return;
                    }
                    jcTree.accept(new TreeTranslator((Element)element, elementUtils, valueTypeElement, names){
                        final /* synthetic */ Element val$element;
                        final /* synthetic */ Elements val$elementUtils;
                        final /* synthetic */ TypeElement val$valueTypeElement;
                        final /* synthetic */ Names val$names;
                        {
                            this.val$element = element;
                            this.val$elementUtils = elements;
                            this.val$valueTypeElement = typeElement2;
                            this.val$names = names;
                        }

                        @Override
                        public void visitClassDef(JCTree.JCClassDecl jcClassDecl) {
                            treeMaker.pos = jcClassDecl.pos;
                            if (EnumProcessor.isNonImplement(jcClassDecl.implementing, enumValueTypeElement)) {
                                EnumProcessor.autoImportPackage(javacTrees.getPath(this.val$element), treeMaker, this.val$elementUtils, new Element[]{enumValueTypeElement});
                                EnumProcessor.autoImplementEnumValue(jcClassDecl, treeMaker, enumValueTypeElement, this.val$valueTypeElement);
                                EnumProcessor.addValueFieldAndConstructor(jcClassDecl, this.val$element, this.val$valueTypeElement, treeMaker, this.val$names);
                            }
                            EnumProcessor.autoImportPackage(javacTrees.getPath(this.val$element), treeMaker, this.val$elementUtils, new Element[]{this.val$valueTypeElement});
                            EnumProcessor.addValueOfMethod(jcClassDecl, enumValueTypeElement, this.val$valueTypeElement, treeMaker, this.val$names);
                            super.visitClassDef(jcClassDecl);
                        }

                        @Override
                        public void visitTopLevel(JCTree.JCCompilationUnit jcCompilationUnit) {
                            super.visitTopLevel(jcCompilationUnit);
                        }
                    });
                } else {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, jcTree + " not is enum.");
                }
            });
            return true;
        }

        private static void addValueOfMethod(JCTree.JCClassDecl jcClassDecl, TypeElement enumValueTypeElement, TypeElement valueTypeElement, TreeMaker treeMaker, Names names) {
            if (EnumProcessor.hasValueOfMethod(jcClassDecl, treeMaker.Modifiers(1L), valueTypeElement, names)) {
                return;
            }
            JCTree.JCFieldAccess enumValueOfMethod = treeMaker.Select((JCTree.JCExpression)treeMaker.Ident((Symbol)((Object)enumValueTypeElement)), names.fromString(VALUE_OF_METHOD_NAME));
            JCTree.JCFieldAccess enumClass = treeMaker.Select((JCTree.JCExpression)treeMaker.Ident(jcClassDecl.sym), names._class);
            JCTree.JCVariableDecl paramValue = treeMaker.VarDef(treeMaker.Modifiers(0x200000000L), names.fromString(ENUM_VALUE_METHOD_NAME), treeMaker.Ident((Symbol)((Object)valueTypeElement)), null);
            JCTree.JCMethodInvocation methodInvocation = treeMaker.Apply(List.nil(), enumValueOfMethod, List.of(enumClass, treeMaker.Ident(names.fromString(ENUM_VALUE_METHOD_NAME))));
            JCTree.JCReturn aReturn = treeMaker.Return(methodInvocation);
            JCTree.JCBlock block = treeMaker.Block(0L, List.of(aReturn));
            JCTree.JCVariableDecl valueDecl = treeMaker.VarDef(new Symbol.VarSymbol(18L, names.fromString(ENUM_VALUE_METHOD_NAME), jcClassDecl.sym.type, jcClassDecl.sym), null);
            JCTree.JCMethodDecl methodDecl = treeMaker.MethodDef(treeMaker.Modifiers(9L), names.fromString(VALUE_OF_METHOD_NAME), (JCTree.JCExpression)valueDecl.getType(), List.nil(), List.of(paramValue), List.nil(), block, null);
            jcClassDecl.defs = jcClassDecl.defs.append(methodDecl);
        }

        private static boolean hasValueOfMethod(JCTree.JCClassDecl jcClassDecl, JCTree.JCModifiers modifiers, TypeElement valueTypeElement, Names names) {
            java.util.List enclosedElements;
            List<JCTree> defs = jcClassDecl.defs;
            for (JCTree jcTree : defs) {
                java.util.List parameters;
                if (!(jcTree instanceof JCTree.JCMethodDecl)) continue;
                JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)jcTree;
                if (methodDecl.sym == null || !methodDecl.sym.isStatic() || !((Object)methodDecl.sym.getSimpleName()).equals(names.fromString(VALUE_OF_METHOD_NAME)) || (parameters = methodDecl.getParameters()) == null || ((List)parameters).size() != 1) continue;
                JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)((List)parameters).get(0);
                if (!jcVariableDecl.sym.type.asElement().getQualifiedName().equals(valueTypeElement.getQualifiedName())) continue;
                return true;
            }
            if (jcClassDecl.sym != null && (enclosedElements = jcClassDecl.sym.getEnclosedElements()) != null && enclosedElements.size() > 0) {
                return EnumProcessor.hasStaticMethod(enclosedElements, modifiers, names.fromString(VALUE_OF_METHOD_NAME), valueTypeElement);
            }
            return false;
        }

        private static boolean hasStaticMethod(Iterable<Symbol> symbols, JCTree.JCModifiers modifier, javax.lang.model.element.Name methodName, TypeElement ... typeElements) {
            for (Symbol symbol : symbols) {
                Symbol.MethodSymbol methodSymbol;
                if (!(symbol instanceof Symbol.MethodSymbol) || !(methodSymbol = (Symbol.MethodSymbol)symbol).isStatic() || !EnumProcessor.hasModifier(methodSymbol, (Modifier)((Object)modifier.getFlags().toArray()[0])) || !((Object)methodSymbol.getSimpleName()).equals(methodName) || !EnumProcessor.equals((List<Symbol.VarSymbol>)methodSymbol.getParameters(), typeElements)) continue;
                return true;
            }
            return false;
        }

        private static boolean equals(List<Symbol.VarSymbol> varSymbols, TypeElement ... typeElements) {
            if (varSymbols == null || varSymbols.size() < 1) {
                return typeElements == null || typeElements.length < 1;
            }
            if (typeElements == null || typeElements.length < 1) {
                return false;
            }
            for (int i = 0; i < typeElements.length; ++i) {
                if (varSymbols.get((int)i).type.asElement().getQualifiedName().equals(typeElements[i].getQualifiedName())) continue;
                return false;
            }
            return true;
        }

        private static boolean hasModifier(Symbol.MethodSymbol methodSymbol, Modifier modifier) {
            Set<Modifier> modifiers = methodSymbol.getModifiers();
            if (modifiers != null && modifiers.size() > 0) {
                for (Modifier item : modifiers) {
                    if (!item.equals((Object)modifier)) continue;
                    return true;
                }
            }
            return false;
        }

        private static JCTree overrideValueMethod(JCTree.JCVariableDecl field, TreeMaker treeMaker, Names names) {
            return treeMaker.MethodDef(treeMaker.Modifiers(1L), names.fromString(ENUM_VALUE_METHOD_NAME), (JCTree.JCExpression)field.getType(), List.nil(), List.nil(), List.nil(), treeMaker.Block(0L, List.of(treeMaker.Return(treeMaker.Select((JCTree.JCExpression)treeMaker.Ident(names._this), names.fromString(field.getName().toString()))))), null);
        }

        private static void addValueFieldAndConstructor(JCTree.JCClassDecl jcClassDecl, Element element, Element valueTypeElement, TreeMaker treeMaker, Names names) {
            ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
            listBuffer.appendList(EnumProcessor.removeConstructor(jcClassDecl.defs));
            String fieldName = (element.getSimpleName().toString() + "_value").toLowerCase();
            JCTree.JCVariableDecl valueDecl = treeMaker.VarDef(new Symbol.VarSymbol(18L, names.fromString(fieldName), ((Symbol)valueTypeElement).type, jcClassDecl.sym), null);
            listBuffer.append(valueDecl);
            listBuffer.appendList(EnumProcessor.addConstructor(valueDecl, treeMaker, names));
            listBuffer.append(EnumProcessor.overrideValueMethod(valueDecl, treeMaker, names));
            jcClassDecl.defs = listBuffer.toList();
        }

        private static List<JCTree> addConstructor(JCTree.JCVariableDecl field, TreeMaker treeMaker, Names names) {
            ListBuffer<JCTree.JCMethodDecl> list = new ListBuffer<JCTree.JCMethodDecl>();
            Symbol.VarSymbol paramSymbol = new Symbol.VarSymbol(0x200000000L, field.name, field.type, field.sym);
            JCTree.JCFieldAccess _this = treeMaker.Select((JCTree.JCExpression)treeMaker.Ident(names._this), field.name);
            JCTree.JCAssign assign = treeMaker.Assign(_this, treeMaker.Ident(field));
            JCTree.JCBlock block = treeMaker.Block(0L, List.of(treeMaker.Exec(assign)));
            Type.MethodType methodType = new Type.MethodType(List.of(field.type), new Type.JCVoidType(), List.nil(), null);
            Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(0L, names.init, methodType, treeMaker.VarDef((Symbol.VarSymbol)paramSymbol, null).sym);
            methodSymbol.params = List.of(paramSymbol);
            if (field.getType().toString().equals(JAVA_STRING_CLASS_NAME)) {
                Type.MethodType noParamMethodType = new Type.MethodType(List.nil(), new Type.JCVoidType(), List.nil(), null);
                JCTree.JCAssign name = treeMaker.Assign(_this, treeMaker.Apply(List.nil(), treeMaker.Select((JCTree.JCExpression)treeMaker.Ident(names._this), names.fromString("name")), List.nil()));
                list.add(treeMaker.MethodDef(new Symbol.MethodSymbol(0L, names.init, noParamMethodType, treeMaker.VarDef((Symbol.VarSymbol)paramSymbol, null).sym), treeMaker.Block(0L, List.of(treeMaker.Exec(name)))));
            }
            list.add(treeMaker.MethodDef(methodSymbol, block));
            return list.toList();
        }

        private static List<JCTree> removeConstructor(List<JCTree> defs) {
            ListBuffer<JCTree> list = new ListBuffer<JCTree>();
            for (JCTree jcTree : defs) {
                if (!(jcTree instanceof JCTree.JCMethodDecl)) {
                    list.append(jcTree);
                    continue;
                }
                JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)jcTree;
                if (methodDecl.sym.isConstructor()) continue;
                list.append(jcTree);
            }
            return list.toList();
        }

        private static TypeElement getEnumValueType(Element element, Elements elementUtils, Names names) {
            java.util.List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            if (annotationMirrors == null || annotationMirrors.size() < 1) {
                return null;
            }
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().equals(elementUtils.getTypeElement(Enum.class.getName()).getSimpleName())) continue;
                Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
                if (elementValues == null) {
                    return null;
                }
                ExecutableElement valueType = elementValues.keySet().stream().filter(key -> key.getSimpleName().equals(names.fromString(VALUE_TYPE_CLASS_NAME))).findFirst().orElse(null);
                if (valueType == null) {
                    return elementUtils.getTypeElement(Integer.class.getName());
                }
                AnnotationValue annotationValue = elementValues.get(valueType);
                return elementUtils.getTypeElement(annotationValue.getValue().toString());
            }
            return null;
        }

        private static void autoImplementEnumValue(JCTree.JCClassDecl jcClassDecl, TreeMaker treeMaker, Element enumValueElement, Element valueTypeElement) {
            ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
            listBuffer.appendList(jcClassDecl.implementing);
            if (EnumProcessor.isNonImplement(jcClassDecl.implementing, enumValueElement)) {
                listBuffer.append(treeMaker.TypeApply(treeMaker.Ident((Symbol)enumValueElement), List.of(treeMaker.Ident(jcClassDecl.sym), treeMaker.Ident((Symbol)valueTypeElement))));
            }
            jcClassDecl.implementing = listBuffer.toList();
        }

        private static boolean isNonImplement(List<JCTree.JCExpression> implementing, Element element) {
            for (JCTree.JCExpression item : implementing) {
                Symbol.TypeSymbol symbol;
                Type type;
                JCTree tree = item.getTree();
                if (tree == null || (type = tree.type) == null || (symbol = type.asElement()) == null || !((Object)symbol.getSimpleName()).equals(element.getSimpleName())) continue;
                return false;
            }
            return true;
        }

        private static void autoImportPackage(TreePath treePath, TreeMaker treeMaker, Elements elementUtils, Element ... elements) {
            CompilationUnitTree compilationUnit = treePath.getCompilationUnit();
            if (compilationUnit instanceof JCTree.JCCompilationUnit) {
                JCTree.JCCompilationUnit jcCompilationUnit = (JCTree.JCCompilationUnit)compilationUnit;
                java.util.List imports = jcCompilationUnit.getImports();
                for (Element element : elements) {
                    if (EnumProcessor.isImport((List<JCTree.JCImport>)imports, element.getSimpleName())) continue;
                    JCTree.JCImport anImport = treeMaker.Import(treeMaker.Select((JCTree.JCExpression)treeMaker.Ident((Name)elementUtils.getPackageOf(element).getQualifiedName()), (Name)element.getSimpleName()), false);
                    jcCompilationUnit.defs = jcCompilationUnit.defs.append(anImport);
                }
            }
        }

        private static boolean isImport(List<JCTree.JCImport> imports, javax.lang.model.element.Name name) {
            for (JCTree.JCImport jcImport : imports) {
                JCTree.JCFieldAccess qualid = jcImport.qualid;
                if (!qualid.sym.name.equals(name)) continue;
                return true;
            }
            return false;
        }
    }
}

