/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.validation;

import cn.hutool.core.collection.CollUtil;
import cn.lingyangwl.framework.tool.core.exception.ArgumentNotValidException;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidationUtils.class);
    private static final Validator VALIDATOR_FAST = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory().getValidator();
    private static final Validator VALIDATOR_ALL = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(false)).buildValidatorFactory().getValidator();

    public static <T> Set<ConstraintViolation<T>> validateFast(T domain) {
        Set validateResult = VALIDATOR_FAST.validate(domain, new Class[0]);
        if (validateResult.size() > 0) {
            ConstraintViolation next = (ConstraintViolation)validateResult.iterator().next();
            log.error("{}: {}", (Object)next.getPropertyPath(), (Object)next.getMessage());
        }
        return validateResult;
    }

    public static <T> void validateFastThrow(T domain) {
        Set validateResult = VALIDATOR_FAST.validate(domain, new Class[0]);
        if (validateResult.size() > 0) {
            ConstraintViolation next = (ConstraintViolation)validateResult.iterator().next();
            throw new ArgumentNotValidException("{}: {}", new Object[]{next.getPropertyPath(), next.getMessage()});
        }
    }

    public static <T> Set<ConstraintViolation<T>> validateAll(T domain) {
        Set validateResult = VALIDATOR_ALL.validate(domain, new Class[0]);
        StringBuilder sb = new StringBuilder();
        if (validateResult.size() > 0) {
            for (ConstraintViolation cv : validateResult) {
                sb.append(cv.getPropertyPath()).append(": ").append(cv.getMessage());
            }
            log.error(sb.toString());
        }
        return validateResult;
    }

    public static <T> void validateAllThrow(T domain) {
        Set validateResult = VALIDATOR_ALL.validate(domain, new Class[0]);
        StringBuilder sb = new StringBuilder();
        if (validateResult.size() > 0) {
            for (ConstraintViolation cv : validateResult) {
                sb.append(cv.getPropertyPath()).append(": ").append(cv.getMessage());
            }
            throw new ArgumentNotValidException("{}", new Object[]{sb.toString()});
        }
    }

    public static void validate(Validator validator, Object object, Class<?> ... groups) {
        Set constraintViolations = validator.validate(object, (Class[])groups);
        if (CollUtil.isNotEmpty((Collection)constraintViolations)) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }
}

