/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.validation;

import cn.lingyangwl.framework.validation.EnumValidate;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Validator.class})
public @interface EnumValue {
    public String message() default "{custom.value.invalid}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public Class<? extends Enum<?>> enumClass();

    public static class Validator
    implements ConstraintValidator<EnumValue, Object> {
        private static final Logger log = LoggerFactory.getLogger(EnumValue.class);
        private Class<? extends Enum<?>> enumClass;
        private static final String ENUM_METHOD = "addMessage";

        public void initialize(EnumValue enumValue) {
            this.enumClass = enumValue.enumClass();
        }

        public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
            if (value == null) {
                return Boolean.TRUE;
            }
            if (this.enumClass == null) {
                return Boolean.TRUE;
            }
            Class<?> valueClass = value.getClass();
            try {
                EnumValidate[] enums = (EnumValidate[])this.enumClass.getEnumConstants();
                if (enums == null || enums.length == 0) {
                    return false;
                }
                return enums[0].isExistCode(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

