/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.storage.base.manager;

import cn.lingyangwl.framework.core.utils.spring.SpringUtils;
import cn.lingyangwl.framework.storage.base.config.StorageProperties;
import cn.lingyangwl.framework.storage.base.constants.FileStorageEnum;
import cn.lingyangwl.framework.storage.base.manager.StorageManager;
import cn.lingyangwl.framework.tool.core.exception.Assert;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;

public abstract class BaseStorageManager
implements StorageManager {
    private static StorageProperties storageProperties;
    private static final Map<FileStorageEnum, StorageManager> storageManagerCache;

    @PostConstruct
    public void initBaseStorageManager() {
        storageProperties = (StorageProperties)SpringUtils.getBean(StorageProperties.class);
        storageManagerCache.put(this.storageType(), this);
    }

    public static StorageManager get() {
        StorageManager storageManager = storageManagerCache.get((Object)storageProperties.getStorage());
        Assert.notNull((Object)storageManager, (String)("\u672a\u5b9e\u73b0 " + (Object)((Object)storageProperties.getStorage()) + " \u5b58\u50a8\u5668, \u8bf7\u8054\u7cfb\u63d0\u4f9b\u8005"));
        return storageManager;
    }

    public static StorageManager get(FileStorageEnum storage) {
        StorageManager storageManager = storageManagerCache.get((Object)storage);
        Assert.notNull((Object)storageManager, (String)("\u672a\u5b9e\u73b0 " + (Object)((Object)storage) + " \u5b58\u50a8\u5668, \u8bf7\u8054\u7cfb\u63d0\u4f9b\u8005"));
        return storageManager;
    }

    public abstract FileStorageEnum storageType();

    static {
        storageManagerCache = new ConcurrentHashMap<FileStorageEnum, StorageManager>();
    }
}

