/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.sms.manager;

import cn.lingyangwl.framework.sms.manager.ISmsManager;
import cn.lingyangwl.framework.sms.manager.entity.JMSmsReps;
import cn.lingyangwl.framework.sms.manager.entity.JMSmsReq;
import cn.lingyangwl.framework.sms.properties.JMSmsProperties;
import cn.lingyangwl.framework.tool.core.StringUtils;
import cn.lingyangwl.framework.tool.core.exception.Assert;
import cn.lingyangwl.framework.tool.core.exception.BizException;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class JMSmsManager
implements ISmsManager<JMSmsReq, JMSmsReps> {
    private static final Logger log = LoggerFactory.getLogger(JMSmsManager.class);
    private final JMSmsProperties jmSmsProperties;
    private static final String URL_TEMPLATE = "https://jmsms.market.alicloudapi.com/sms/send?mobile=%s&templateId=%s&value=%s";
    private static final Integer SUCCESS_CODE = 200;
    private final RestTemplate restTemplate;

    public JMSmsManager(JMSmsProperties jmSmsProperties, RestTemplate restTemplate) {
        this.jmSmsProperties = jmSmsProperties;
        this.restTemplate = restTemplate;
    }

    @Override
    public JMSmsReps send(JMSmsReq req) {
        String appcode = this.jmSmsProperties.getAppCode();
        String mobile = (String)StringUtils.toList((String)req.getPhoneNumbers(), (String)",", String.class).get(0);
        String value = Optional.ofNullable(req.getTemplateParam().getString("value")).orElseThrow(() -> new BizException("please input value"));
        String url = String.format(URL_TEMPLATE, mobile, req.getTemplateId(), value);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", " APPCODE " + appcode);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
        HttpStatus statusCode = response.getStatusCode();
        String body = (String)response.getBody();
        if (statusCode != HttpStatus.OK) {
            log.error("send sms fail, resp: {}, url: {}", (Object)body, (Object)url);
            return JMSmsReps.builder().isSuccess(false).code(String.valueOf(statusCode.value())).requestId("").bizId("").message(body).build();
        }
        Assert.notNull((Object)body, (String)"resp body is null");
        log.debug("sms resp: {}", (Object)body);
        JSONObject jsonObject = JSON.parseObject((String)body);
        Integer code = jsonObject.getInteger("code");
        String msg = jsonObject.getString("msg");
        String taskNo = jsonObject.getString("taskNo");
        Assert.notNull((Object)code, (String)(url + " response code is null"));
        if (SUCCESS_CODE.compareTo(code) == 0) {
            String taskId = jsonObject.getJSONObject("data").getString("taskId");
            return JMSmsReps.builder().isSuccess(true).code(String.valueOf(code)).requestId(taskNo).bizId(taskId).message(msg).build();
        }
        return JMSmsReps.builder().isSuccess(false).code(String.valueOf(code)).requestId(taskNo).bizId("").message(msg).build();
    }
}

