/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.sms.manager;

import cn.lingyangwl.framework.sms.manager.ISmsManager;
import cn.lingyangwl.framework.sms.manager.entity.AliyunSmsReps;
import cn.lingyangwl.framework.sms.manager.entity.AliyunSmsReq;
import cn.lingyangwl.framework.sms.properties.AliyunSmsProperties;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunSmsManager
implements ISmsManager<AliyunSmsReq, AliyunSmsReps> {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsManager.class);
    private static final String PRODUCT = "Dysmsapi";
    private static final String DOMAIN = "dysmsapi.aliyuncs.com ";
    private static final String SUCCESS_CODE = "OK";
    private final AliyunSmsProperties aliyunSmsProperties;
    private IAcsClient acsClient;

    public AliyunSmsManager(AliyunSmsProperties aliyunSmsProperties) {
        this.aliyunSmsProperties = aliyunSmsProperties;
        this.init();
    }

    private void init() {
        String accessKeySecret = this.aliyunSmsProperties.getAccessKeySecret();
        String accessKeyId = this.aliyunSmsProperties.getAccessKeyId();
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)PRODUCT, (String)"cn-hangzhou");
        this.acsClient = new DefaultAcsClient((IClientProfile)profile);
    }

    @Override
    public AliyunSmsReps send(AliyunSmsReq req) {
        req.check();
        SendSmsRequest request = new SendSmsRequest();
        request.setSysMethod(MethodType.POST);
        request.setPhoneNumbers(req.getPhoneNumbers());
        request.setSignName(req.getSignName());
        request.setTemplateCode(req.getTemplateId());
        request.setTemplateParam(req.getTemplateParam().toJSONString(new JSONWriter.Feature[0]));
        request.setSmsUpExtendCode(req.getSmsUpExtendCode());
        request.setOutId(req.getOutId());
        try {
            SendSmsResponse sendSmsResponse = (SendSmsResponse)this.acsClient.getAcsResponse((AcsRequest)request);
            return AliyunSmsReps.builder().code(sendSmsResponse.getCode()).message(sendSmsResponse.getMessage()).isSuccess(SUCCESS_CODE.equals(sendSmsResponse.getCode())).requestId(sendSmsResponse.getRequestId()).build();
        }
        catch (ClientException e) {
            log.error("send sms fail, errorCode: {}, errorMessage: {}", (Object)e.getErrCode(), (Object)e.getMessage());
            return AliyunSmsReps.builder().code(e.getErrCode()).message(e.getMessage()).isSuccess(false).requestId(e.getRequestId()).build();
        }
    }
}

