/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.sms;

import cn.lingyangwl.framework.sms.manager.JMSmsManager;
import cn.lingyangwl.framework.sms.properties.JMSmsProperties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@ConditionalOnProperty(prefix="lingyang-framework.sms.ju-mei", value={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={JMSmsProperties.class})
public class LyJMSmsAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LyJMSmsAutoConfiguration.class);
    @Resource
    private JMSmsProperties jmSmsProperties;
    @Resource
    private RestTemplate restTemplate;

    @PostConstruct
    public void init() {
        log.info("init {}", (Object)this.getClass().getSimpleName());
    }

    @Bean
    public JMSmsManager aliyunSmsManager() {
        return new JMSmsManager(this.jmSmsProperties, this.restTemplate);
    }
}

