package cn.lingyangwl.framework.security.xss.config;

import cn.lingyangwl.framework.core.constant.LyCoreConstants;
import cn.lingyangwl.framework.tool.core.CollectionUtils;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

/**
 * XSS跨站脚本配置
 *
 * @author shenguangyang
 */
@Getter
@Setter
@Configuration
@ConfigurationProperties(prefix = LyCoreConstants.PROPERTIES_PRE + "security.xss")
public class SecurityXssProperties {
    public static final String PREFIX = LyCoreConstants.PROPERTIES_PRE + "security.xss";
    /**
     * Xss开关
     */
    private boolean enabled = false;

    /**
     * 模式：clear 清理（默认），escape 转义
     */
    private Mode mode = Mode.clear;

    /**
     * [clear 专用] prettyPrint，默认关闭： 保留换行
     */
    private boolean prettyPrint = false;

    /**
     * [clear 专用] 使用转义，默认关闭
     */
    private boolean enableEscape = false;

    /**
     * 全局：对文件进行首尾 trim
     */
    private boolean trimText = true;

    /**
     * 拦截的路由，默认为空
     */
    private List<String> pathPatterns = new ArrayList<>();

    /**
     * 放行的路由，默认为空
     */
    private List<String> pathExcludePatterns = new ArrayList<>();

    @PostConstruct
    public void init() {
        // 处理采用逗号分割的多个url
        CollectionUtils.unFlatCollection(",", pathPatterns);
        CollectionUtils.unFlatCollection(",", pathExcludePatterns);
    }

    public enum Mode {

        /**
         * 清理
         */
        clear,
        /**
         * 转义
         */
        escape,
        /**
         * 校验，抛出异常
         */
        validate;

    }
}
