package cn.lingyangwl.framework.security.submit;

import cn.lingyangwl.framework.tool.core.exception.Assert;
import cn.lingyangwl.framework.tool.core.exception.BaseError;
import lombok.*;

import javax.annotation.PostConstruct;
import java.util.function.Supplier;

/**
 * 重复提交的用户, 需要使用方自己进行配置
 * @author shenguangyang
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class RepeatSubmitDefinition {
    /**
     * 指定用户id
     */
    private Supplier<String> userId;

    /**
     * 当重复提交时候抛出的异常
     */
    private BaseError baseError;

    /**
     * 缓存key的前缀
     */
    @Builder.Default
    private String keyPrefix = "repeat_submit";

    /**
     * 防重提交方式为: 令牌模式 {@link RepeatSubmit#limitType()}, 请求头中的 token key
     */
    @Builder.Default
    private String headerTokenKey = "request-token";

    @PostConstruct
    public void init() {
        check();
    }

    public void check() {
        Assert.notNull(userId, "userId function is null, please config");
        Assert.notNull(baseError, "baseError is null, please config");
        Assert.notEmpty(headerTokenKey, "headerTokenKey is null, please config");
    }
}
