package cn.lingyangwl.framework.security.submit;

import java.lang.annotation.*;

/**
 * 可以防止重复提交的注解, 底层使用redis
 * @author shenguangyang
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RepeatSubmit {
    /**
     * 防重提交方式
     */
    Type limitType() default Type.IP;

    /**
     * 加锁过期时间, 默认是5s, 针对 {@link Type#IP} 模式
     */
    long lockTime() default 5;

    /**
     * 防重提交, 支持两种方式, 一个是ip, 一个是令牌
     */
    enum Type {
        /**
         * 缓存中的key = ip+类+方法
         */
        IP,
        /**
         * 缓存中的key = token, 需要使用方调用指定的方法先获取token, 再拿着token请求
         */
        TOKEN
    }
}
