package cn.lingyangwl.framework.rabbitmq.repeatconsume;

import cn.lingyangwl.framework.cache.core.service.CacheService;
import cn.lingyangwl.framework.mq.base.enums.MqCacheKey;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @deprecated
 * @author shenguangyang
 */
@Service
public class MqRepeatConsumeServiceImpl implements MqRepeatConsumeService {
    @Resource
    private CacheService cacheService;

    @Override
    public boolean isConsumed(String msgId) {
        MqCacheKey mqCacheKey = MqCacheKey.REPEAT_CONSUME;
        String key = mqCacheKey.formatKey(msgId);
        return cacheService.opsForValue().get(key) != null;
    }

    @Override
    public void markConsumed(String msgId) {
        MqCacheKey mqCacheKey = MqCacheKey.REPEAT_CONSUME;
        cacheService.opsForValue().setEx("1", mqCacheKey, msgId);
    }
}
