package cn.lingyangwl.framework.rabbitmq.config;

/**
 * 交换机类型
 * exchange有多个种类，常用的有direct，fanout，topic。前三种类似集合对应关系那样，（direct）1:1,（fanout）1：N,（topic）N:1
 *
 * @author shenguangyang
 */
public enum ExchangeType {
    /**
     * 直连交换机（全文匹配）
     * 1:1类似完全匹配
     * 生产者和消费者，具有相同的交换机名称（Exchange）、交换机类型和相同的密匙（routingKey），那么消费者即可成功获取到消息
     */
    DIRECT("direct"),
    /**
     * 通配符交换机（两种通配符：*只能匹配一个单词且必须有一个，#可以匹配零个或多个）
     * <p>
     * 多个交换器可以路由消息到同一个队列。根据模糊匹配，比如一个队列的routing key
     * 为*.test ，那么凡是到达交换器的消息中的routing key 后缀.test都被路由到这个队列上。
     */
    TOPIC("topic"),
    /**
     * 头交换机（自定义键值对匹配，根据发送消息内容中的headers属性进行匹配）
     */
    HEADERS("headers"),
    /**
     * 扇形（广播）交换机 （将消息转发到所有与该交互机绑定的队列上）
     * <p>
     * 1：N 可以把一个消息并行发布到多个队列上去，简单的说就是，当多个队列绑定到fanout的交换器,
     * 那么交换器一次性拷贝多个消息分别发送到绑定的队列上，每个队列有这个消息的副本。
     * <p>
     * ps：这个可以在业务上实现并行处理多个任务，比如，用户上传图片功能，当消息到达交换器上，它可
     * 以同时路由到积分增加队列和其它队列上，达到并行处理的目的，并且易扩展，以后有什么并行任务的
     * 时候，直接绑定到fanout交换器不需求改动之前的代码。
     */
    FANOUT("fanout");

    private final String value;

    ExchangeType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
}
