/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.mybatis.mate.interceptor;

import cn.lingyangwl.framework.data.mate.fieldbind.FieldBindHandler;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class MybatisFieldBindCustomInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisFieldBindCustomInterceptor.class);
    private final FieldBindHandler fieldBindHandler;
    private static final TransmittableThreadLocal<Long> ttl = new TransmittableThreadLocal();

    public MybatisFieldBindCustomInterceptor(FieldBindHandler fieldBindHandler) {
        this.fieldBindHandler = fieldBindHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = mappedStatement.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(mappedStatement, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        List query = executor.query(mappedStatement, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        Long threadId = (Long)ttl.get();
        if (threadId != null && threadId.longValue() == Thread.currentThread().getId()) {
            return query;
        }
        ttl.set((Object)Thread.currentThread().getId());
        try {
            this.fieldBindHandler.handleField((Object)query);
        }
        catch (Exception e) {
            log.error("field bind fail, error: ", (Throwable)e);
        }
        finally {
            ttl.remove();
        }
        return query;
    }

    public Object plugin(Object obj) {
        return Plugin.wrap((Object)obj, (Interceptor)this);
    }

    public void setProperties(Properties arg0) {
    }

    private String getOperateType(Invocation invocation) {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        SqlCommandType commondType = ms.getSqlCommandType();
        if (commondType.compareTo((Enum)SqlCommandType.SELECT) == 0) {
            return "select";
        }
        if (commondType.compareTo((Enum)SqlCommandType.INSERT) == 0) {
            return "insert";
        }
        if (commondType.compareTo((Enum)SqlCommandType.UPDATE) == 0) {
            return "update";
        }
        if (commondType.compareTo((Enum)SqlCommandType.DELETE) == 0) {
            return "delete";
        }
        return null;
    }
}

