/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.mybatis.mate.fieldunique;

import cn.lingyangwl.framework.core.utils.servlet.ServletUtils;
import cn.lingyangwl.framework.mybatis.mate.annotations.FieldUnique;
import cn.lingyangwl.framework.mybatis.mate.annotations.FieldUniqueConfig;
import cn.lingyangwl.framework.mybatis.mate.enums.OperationTypeEnum;
import cn.lingyangwl.framework.mybatis.mate.fieldunique.CheckInfoBefore;
import cn.lingyangwl.framework.mybatis.mate.fieldunique.FieldUniqueInfo;
import cn.lingyangwl.framework.mybatis.mate.fieldunique.IFieldUniqueCheckLock;
import cn.lingyangwl.framework.mybatis.mate.mapper.MybatisCommonMapper;
import cn.lingyangwl.framework.tool.core.CollectionUtils;
import cn.lingyangwl.framework.tool.core.ObjectUtils;
import cn.lingyangwl.framework.tool.core.SqlUtils;
import cn.lingyangwl.framework.tool.core.StringUtils;
import cn.lingyangwl.framework.tool.core.exception.Assert;
import cn.lingyangwl.framework.tool.core.exception.BizException;
import com.baomidou.mybatisplus.annotation.TableName;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

public class FieldUniqueCore {
    private static final Map<String, FieldUniqueInfo> fieldUniqueInfoMap = new ConcurrentHashMap<String, FieldUniqueInfo>();
    private static final DefaultObjectFactory defaultObjectFactory = new DefaultObjectFactory();
    private static final DefaultObjectWrapperFactory defaultObjectWrapperFactory = new DefaultObjectWrapperFactory();
    private static final DefaultReflectorFactory defaultReflectorFactory = new DefaultReflectorFactory();
    private static MybatisCommonMapper mybatisCommonMapper;
    private static IFieldUniqueCheckLock fieldUniqueCheckLock;

    public static void setFieldUniqueCheckLock(IFieldUniqueCheckLock fieldUniqueCheckLock) {
        FieldUniqueCore.fieldUniqueCheckLock = fieldUniqueCheckLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FieldUniqueInfo get(Object object) {
        if (object == null) {
            return null;
        }
        String key = object.getClass().getName();
        if (!fieldUniqueInfoMap.containsKey(key)) {
            String string = key.intern();
            synchronized (string) {
                if (!fieldUniqueInfoMap.containsKey(key)) {
                    TableName tableNameAnnotation = object.getClass().getAnnotation(TableName.class);
                    FieldUniqueConfig fieldUniqueConfig = object.getClass().getAnnotation(FieldUniqueConfig.class);
                    Assert.notNull((Object)fieldUniqueConfig, (String)(object.getClass().getName() + " class have not @FieldUniqueConfig annotation"));
                    String tableName = tableNameAnnotation == null ? StringUtils.humpToUnderline((String)object.getClass().getSimpleName()) : tableNameAnnotation.value();
                    List fields = ObjectUtils.getFields((Object)object);
                    FieldUniqueInfo fieldUniqueInfo = new FieldUniqueInfo();
                    fieldUniqueInfo.setTargetClass(object.getClass());
                    fieldUniqueInfo.setTableName(tableName);
                    fieldUniqueInfo.setFieldUniqueConfig(fieldUniqueConfig);
                    fieldUniqueInfo.setTableIdName(fieldUniqueConfig.tableId());
                    fieldUniqueInfo.setEntityIdName(fieldUniqueConfig.entityId());
                    for (Field field : fields) {
                        if (!field.isAnnotationPresent(FieldUnique.class)) continue;
                        FieldUniqueInfo.FieldUniqueDefinition fieldUniqueDefinition = new FieldUniqueInfo.FieldUniqueDefinition();
                        FieldUnique annotation = field.getAnnotation(FieldUnique.class);
                        fieldUniqueDefinition.setField(field);
                        fieldUniqueDefinition.setFieldUnique(annotation);
                        fieldUniqueInfo.add(fieldUniqueDefinition);
                    }
                    fieldUniqueInfoMap.put(key, fieldUniqueInfo);
                }
            }
        }
        return fieldUniqueInfoMap.get(key);
    }

    public static CheckInfoBefore checkBefore(Object object, OperationTypeEnum operationTypeEnum) {
        String tableFieldName;
        String headerKey;
        String entityFieldName;
        Object value;
        FieldUniqueInfo fieldUniqueInfo = FieldUniqueCore.get(object);
        Assert.notNull((Object)operationTypeEnum, (String)"operationType is null");
        if (fieldUniqueInfo == null || CollectionUtils.isEmpty((Collection)fieldUniqueInfo.getFieldUniqueDefinitionMap().get(FieldUnique.Condition.NONE))) {
            return null;
        }
        HashMap<String, String> fieldMessageMap = new HashMap<String, String>();
        StringBuilder sqlSb = new StringBuilder("select ");
        StringBuilder whereSql = new StringBuilder(" where ( 1 = 1 or ");
        StringBuilder cacheKeySb = new StringBuilder(fieldUniqueInfo.getTableName());
        MetaObject metaObject = MetaObject.forObject((Object)object, (ObjectFactory)defaultObjectFactory, (ObjectWrapperFactory)defaultObjectWrapperFactory, (ReflectorFactory)defaultReflectorFactory);
        List fieldUniqueDefinitions = fieldUniqueInfo.getFieldUniqueDefinitionMap().getOrDefault(FieldUnique.Condition.NONE, Collections.emptyList());
        int length = fieldUniqueDefinitions.size();
        String sqlCondition = "or ";
        for (int i = 0; i < length; ++i) {
            Iterator fieldInfo = (FieldUniqueInfo.FieldUniqueDefinition)fieldUniqueDefinitions.get(i);
            FieldUnique fieldUnique = ((FieldUniqueInfo.FieldUniqueDefinition)((Object)fieldInfo)).getFieldUnique();
            String fieldName = "";
            String fieldMessage = "\u6570\u636e\u91cd\u590d";
            if (fieldUnique != null) {
                fieldName = fieldUnique.field();
                fieldMessage = fieldUnique.message();
            }
            String entityFieldName2 = ((FieldUniqueInfo.FieldUniqueDefinition)((Object)fieldInfo)).getField().getName();
            String tableFieldName2 = StringUtils.isEmpty((String)fieldName) ? StringUtils.humpToUnderline((String)entityFieldName2) : fieldName;
            sqlSb.append(tableFieldName2).append(",");
            value = FieldUniqueCore.getFieldValue(fieldInfo, metaObject);
            if (Objects.isNull(value)) continue;
            if (SqlUtils.containsSqlInjection((String)String.valueOf(value))) {
                throw new BizException((CharSequence)"illegal value [{}]", new Object[]{value});
            }
            sqlCondition = i == length - 1 ? "" : fieldUniqueInfo.getFieldUniqueConfig().sqlCondition().getValue();
            whereSql.append(" ").append(tableFieldName2).append(" = ").append("'").append(value).append("' ").append(sqlCondition);
            fieldMessageMap.put(tableFieldName2, fieldMessage);
            cacheKeySb.append(entityFieldName2).append(value);
        }
        String tempWhereSql = whereSql.toString();
        if (tempWhereSql.endsWith(sqlCondition)) {
            whereSql = new StringBuilder(tempWhereSql.substring(0, tempWhereSql.lastIndexOf(sqlCondition)));
        }
        whereSql.append(" ) ");
        for (FieldUniqueInfo.FieldUniqueDefinition fieldInfo : fieldUniqueInfo.getFieldUniqueDefinitionMap().getOrDefault(FieldUnique.Condition.NE, Collections.emptyList())) {
            FieldUnique fieldUniqueNe = fieldInfo.getFieldUnique();
            entityFieldName = fieldInfo.getField().getName();
            headerKey = fieldUniqueNe.headerKey();
            String fieldName = fieldUniqueNe.field();
            Object value2 = StringUtils.isEmpty((String)headerKey) ? FieldUniqueCore.getFieldValue(fieldInfo, metaObject) : ServletUtils.getRequestOfNonNull().getHeader(headerKey);
            if (Objects.isNull(value2)) continue;
            tableFieldName = StringUtils.isEmpty((String)fieldName) ? StringUtils.humpToUnderline((String)entityFieldName) : fieldName;
            whereSql.append(" and ").append(tableFieldName).append(" != ").append("'").append(value2).append("'");
            cacheKeySb.append(entityFieldName).append(value2);
        }
        for (FieldUniqueInfo.FieldUniqueDefinition fieldInfo : fieldUniqueInfo.getFieldUniqueDefinitionMap().getOrDefault(FieldUnique.Condition.EQ, Collections.emptyList())) {
            FieldUnique fieldUnique = fieldInfo.getFieldUnique();
            entityFieldName = fieldInfo.getField().getName();
            headerKey = fieldUnique.headerKey();
            String fieldName = fieldUnique.field();
            value = StringUtils.isNotEmpty((String)headerKey) ? ServletUtils.getRequestOfNonNull().getHeader(headerKey) : FieldUniqueCore.getFieldValue(fieldInfo, metaObject);
            if (Objects.isNull(value)) continue;
            tableFieldName = StringUtils.isEmpty((String)fieldName) ? StringUtils.humpToUnderline((String)entityFieldName) : fieldName;
            whereSql.append(" and ").append(tableFieldName).append(" = ").append("'").append(value).append("'");
            cacheKeySb.append(entityFieldName).append(value);
        }
        String whereSqlStr = whereSql.toString();
        if (operationTypeEnum == OperationTypeEnum.UPDATE) {
            whereSqlStr = whereSqlStr + " and " + fieldUniqueInfo.getTableIdName() + " != " + metaObject.getValue(fieldUniqueInfo.getEntityIdName());
        }
        String sql = sqlSb.substring(0, sqlSb.lastIndexOf(",")) + " from " + fieldUniqueInfo.getTableName() + whereSqlStr;
        return new CheckInfoBefore(object, sql, DigestUtils.md5Hex((String)cacheKeySb.toString()), fieldMessageMap, metaObject);
    }

    private static Object getFieldValue(FieldUniqueInfo.FieldUniqueDefinition fieldInfo, MetaObject metaObject) {
        String value;
        FieldUnique fieldUnique = fieldInfo.getFieldUnique();
        String fieldName = fieldUnique.field();
        String fieldValue = fieldUnique.value();
        String entityFieldName = fieldInfo.getField().getName();
        String string = value = StringUtils.isEmpty((String)fieldValue) ? metaObject.getValue(entityFieldName) : fieldValue;
        if (Objects.isNull(value) || StringUtils.isEmpty((String)String.valueOf(value))) {
            return null;
        }
        return value;
    }

    public static void doCheck(CheckInfoBefore checkInfoBefore) {
        String sql = checkInfoBefore.getSql();
        Map<String, String> fieldMessageMap = checkInfoBefore.getFieldMessageMap();
        MetaObject metaObject = checkInfoBefore.getMetaObject();
        List<Map<String, Object>> result = mybatisCommonMapper.count(sql);
        if (result != null && !result.isEmpty()) {
            for (Map<String, Object> stringObjectMap : result) {
                for (Map.Entry<String, Object> entry : stringObjectMap.entrySet()) {
                    String tableFieldName = entry.getKey();
                    Object dbFieldValue = entry.getValue();
                    Object objectFieldValue = metaObject.getValue(StringUtils.underlineToHump((String)tableFieldName));
                    if (!(objectFieldValue instanceof String ? objectFieldValue.equals(dbFieldValue) && StringUtils.isNotEmpty((String)String.valueOf(objectFieldValue)) : objectFieldValue == dbFieldValue && Objects.nonNull(objectFieldValue))) continue;
                    throw new BizException(fieldMessageMap.get(tableFieldName));
                }
            }
        }
    }

    public static void setMybatisCommonMapper(MybatisCommonMapper mapper) {
        mybatisCommonMapper = mapper;
    }

    public static IFieldUniqueCheckLock getFieldUniqueCheckLock() {
        return fieldUniqueCheckLock;
    }
}

