package cn.lingyangwl.framework.mybatis.mate.config;

import cn.lingyangwl.framework.mybatis.mate.interceptor.MybatisFieldBindCustomInterceptor;
import com.github.pagehelper.autoconfigure.PageHelperAutoConfiguration;
import cn.lingyangwl.framework.data.mate.fieldbind.FieldBindHandler;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;

/**
 * @author shenguangyang
 */
@Configuration
@AutoConfigureAfter(PageHelperAutoConfiguration.class)
public class MybatisInterceptorCustomConfig {

    @Resource
    private List<SqlSessionFactory> sqlSessionFactoryList;

    @Resource
    private FieldBindHandler fieldBindHandler;

    /**
     * 可解决 spring boot 在使用 pagehelper-spring-boot-starter 后 ，自定义拦截器失效的问题。
     */
    @PostConstruct
    public void addMySqlInterceptor() {
        MybatisFieldBindCustomInterceptor fieldBindCustomInterceptor = new MybatisFieldBindCustomInterceptor(fieldBindHandler);
        for (SqlSessionFactory sqlSessionFactory : sqlSessionFactoryList) {
            sqlSessionFactory.getConfiguration().addInterceptor(fieldBindCustomInterceptor);
        }
    }
}