/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.mybatis.mate.fieldunique;

import cn.lingyangwl.framework.mybatis.mate.fieldunique.IFieldUniqueCheckLock;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.redis.core.RedisTemplate;

@ConditionalOnClass(value={RedisTemplate.class})
@ConditionalOnMissingBean(value={IFieldUniqueCheckLock.class})
public class FieldUniqueCheckRedisLock
implements IFieldUniqueCheckLock {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    private static final String pre = "field_unique::";

    @Override
    public boolean lock(String cacheKey) throws Exception {
        Boolean success = this.redisTemplate.opsForValue().setIfAbsent((Object)(pre + cacheKey), (Object)"", 5L, TimeUnit.MINUTES);
        return Boolean.TRUE.equals(success);
    }

    @Override
    public void unlock(String cacheKey) {
        this.redisTemplate.delete((Object)(pre + cacheKey));
    }
}

