/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.mybatis.mate.fieldunique;

import cn.lingyangwl.framework.mybatis.mate.annotations.FieldUniqueCheck;
import cn.lingyangwl.framework.mybatis.mate.fieldunique.CheckInfoBefore;
import cn.lingyangwl.framework.mybatis.mate.fieldunique.FieldUniqueCore;
import cn.lingyangwl.framework.mybatis.mate.fieldunique.IFieldUniqueCheckLock;
import cn.lingyangwl.framework.mybatis.mate.inter.EntityFieldUniqueCheck;
import cn.lingyangwl.framework.tool.core.exception.BizException;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class FieldUniqueCheckAspect {
    private static final Logger log = LoggerFactory.getLogger(FieldUniqueCheckAspect.class);

    @Pointcut(value="@annotation(cn.lingyangwl.framework.mybatis.mate.annotations.FieldUniqueCheck)")
    public void fieldUniqueCheckPointCut() {
    }

    @Around(value="fieldUniqueCheckPointCut()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        return this.handleFieldUniqueCheck(pjp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleFieldUniqueCheck(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        FieldUniqueCheck fieldUniqueCheck = this.getAnnotationLog((JoinPoint)pjp);
        if (fieldUniqueCheck == null) {
            return pjp.proceed();
        }
        Object[] args = pjp.getArgs();
        if (args != null && args.length == 1 && (object = args[0]) instanceof EntityFieldUniqueCheck) {
            CheckInfoBefore checkInfoBefore = FieldUniqueCore.checkBefore(object, fieldUniqueCheck.type());
            if (checkInfoBefore == null) {
                return pjp.proceed();
            }
            String cacheKey = checkInfoBefore.getCacheKey();
            IFieldUniqueCheckLock fieldUniqueCheckLock = FieldUniqueCore.getFieldUniqueCheckLock();
            if (fieldUniqueCheckLock != null) {
                if (!fieldUniqueCheckLock.lock(cacheKey)) {
                    throw new BizException("\u5f53\u524d\u6570\u636e\u6b63\u5728\u88ab\u64cd\u4f5c, \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                try {
                    FieldUniqueCore.doCheck(checkInfoBefore);
                    Object object2 = pjp.proceed();
                    return object2;
                }
                finally {
                    fieldUniqueCheckLock.unlock(cacheKey);
                }
            }
            String string = cacheKey.intern();
            synchronized (string) {
                FieldUniqueCore.doCheck(checkInfoBefore);
                return pjp.proceed();
            }
        }
        return pjp.proceed();
    }

    private FieldUniqueCheck getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(FieldUniqueCheck.class);
        }
        return null;
    }
}

