/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.lock.model;

import cn.lingyangwl.framework.lock.exception.LockException;
import cn.lingyangwl.framework.lock.model.LockTemplate;
import cn.lingyangwl.framework.tool.core.exception.Assert;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonLock
extends LockTemplate {
    private static final Logger log = LoggerFactory.getLogger(RedissonLock.class);
    private final RLock rLock;

    public RedissonLock(String lockKey, Redisson redisson) {
        super(lockKey);
        Assert.notNull((Object)redisson, (String)"redisson is null");
        this.rLock = redisson.getLock(lockKey);
    }

    @Override
    public void unlock() {
        if (this.rLock.isLocked() && this.rLock.isHeldByCurrentThread()) {
            this.rLock.unlock();
        }
    }

    @Override
    public boolean isLocked() {
        return this.rLock.isLocked() && this.rLock.isHeldByCurrentThread();
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) {
        try {
            this.rLock.tryLock(waitTime, unit.convert(5L, TimeUnit.SECONDS), unit);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void lock() {
        try {
            this.rLock.lock(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("get lock fail, err: {}", (Object)e.getMessage());
            throw new LockException("get lock fail");
        }
    }
}

